/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.im.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.admin.common.ImChatRoomProperties;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.IMMapper;
import com.bxm.localnews.admin.domain.LocationMapper;
import com.bxm.localnews.admin.dto.im.BlockUserDTO;
import com.bxm.localnews.admin.dto.im.ChatRoomMessageDTO;
import com.bxm.localnews.admin.integration.IMIntegrationService;
import com.bxm.localnews.admin.param.BatchMessageParam;
import com.bxm.localnews.admin.param.ChatRoomOperationParam;
import com.bxm.localnews.admin.param.ChatRoomQueryParam;
import com.bxm.localnews.admin.param.ImMessageQueryParam;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.service.im.IMService;
import com.bxm.localnews.admin.vo.Location;
import com.bxm.localnews.admin.vo.im.HistoryChatBean;
import com.bxm.localnews.admin.vo.im.ImMessageBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTimeComparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IMServiceImpl
extends BaseService
implements IMService {
    private final IMMapper imMapper;
    private final LocationMapper locationMapper;
    private final ImChatRoomProperties imChatRoomProperties;
    private final IMIntegrationService imIntegrationService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private DateTimeComparator dateTimeComparator = DateTimeComparator.getInstance();

    @Autowired
    public IMServiceImpl(IMMapper imMapper, LocationMapper locationMapper, ImChatRoomProperties imChatRoomProperties, IMIntegrationService imIntegrationService, RedisHashMapAdapter redisHashMapAdapter) {
        this.imMapper = imMapper;
        this.locationMapper = locationMapper;
        this.imChatRoomProperties = imChatRoomProperties;
        this.imIntegrationService = imIntegrationService;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public List<ImMessageBean> query(ImMessageQueryParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        List<Object> result = Lists.newArrayList();
        if (null != param.getSender() && null != param.getReceiver()) {
            result.addAll(this.imMapper.query(param));
            long sender = param.getSender();
            param.setSender(param.getReceiver());
            param.setReceiver(Long.valueOf(sender));
            result.addAll(this.imMapper.query(param));
            result = result.stream().sorted((pre, next) -> this.dateTimeComparator.compare((Object)next.getSendTime(), (Object)pre.getSendTime())).collect(Collectors.toList());
        } else {
            result = this.imMapper.query(param);
        }
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            result.forEach(e -> {
                if (StringUtils.equals((CharSequence)"RC:VcMsg", (CharSequence)e.getObjectName())) {
                    e.setDuration(Integer.valueOf(this.getdurationByContent(e.getPrimitiveContent())));
                }
            });
        }
        return result;
    }

    private int getdurationByContent(String content) {
        JSONObject result = JSONObject.parseObject((String)content);
        Integer duration = result.getInteger("duration");
        return duration;
    }

    @Override
    public List<HistoryChatBean> queryHistory(Long userId) {
        return this.imMapper.queryHistory(userId);
    }

    @Override
    public void getVoiceByContent(String id, HttpServletResponse response) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("multipart/form-data");
        response.setHeader("Content-Disposition", "attachment;fileName=" + id + ".amr");
        String content = this.imMapper.selectContentById(id);
        try (ServletOutputStream out = response.getOutputStream();){
            byte[] audioByte = Base64.decode(content);
            out.write(audioByte);
            out.flush();
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u6587\u4ef6\u9519\u8bef", (Throwable)e);
        }
    }

    @Override
    public PageWarper<ChatRoomMessageDTO> queryChatRoomRecord(ChatRoomQueryParam param) {
        Map<String, Location> locationMap = ((LocationService)SpringContextHolder.getBean(LocationService.class)).listLocation();
        PageWarper result = new PageWarper(this.imMapper.queryChatRoomRecord(param));
        result.getList().forEach(e -> {
            String areaCode = e.getAreaCode();
            Location location = (Location)locationMap.get(areaCode);
            if (Objects.nonNull(location)) {
                e.setAreaName(location.getName());
            }
            if (StringUtils.equals((CharSequence)"RC:VcMsg", (CharSequence)e.getObjectName())) {
                e.setDuration(Integer.valueOf(this.getdurationByContent(e.getPrimitiveContent())));
            }
        });
        return result;
    }

    @Override
    public Boolean createChatRoom(String areaCode) {
        Long assistantUserId = this.imChatRoomProperties.getChatRoomTimingRedPacketAssistantUserId();
        Location location = this.locationMapper.selectByCode(areaCode);
        Boolean chatRoom = this.imIntegrationService.createChatRoom(areaCode, assistantUserId, location.getName());
        return chatRoom;
    }

    @Override
    public List<BlockUserDTO> queryChatRoomBlockUser(String chatRoomId) {
        return this.imIntegrationService.queryChatRoomBlockUser(chatRoomId);
    }

    @Override
    public Boolean blockChatRoomUser(String chatRoomId, Date time, Long userId, Long id) {
        ChatRoomOperationParam param = new ChatRoomOperationParam();
        param.setChatRoomId(chatRoomId);
        param.setTargetUserId(userId);
        param.setUserId(id);
        param.setTime(time);
        boolean falg = this.imIntegrationService.blockChatRoomUser(param);
        return falg;
    }

    @Override
    public Boolean unBlockChatRoomUser(String chatRoomId, Long userId, Long id) {
        ChatRoomOperationParam param = new ChatRoomOperationParam();
        param.setChatRoomId(chatRoomId);
        param.setTargetUserId(userId);
        param.setUserId(id);
        Boolean flag = this.imIntegrationService.unBlockChatRoomUser(param);
        return flag;
    }

    @Override
    public Boolean sendBatchMessage(BatchMessageParam batchMessageParam) {
        return this.imIntegrationService.sendBatchMessage(batchMessageParam);
    }

    @Override
    public Boolean clearChatRecord(Long virtualUserId, Long realUserId) {
        KeyGenerator unReplyNumKey = RedisConfig.VIRTURE_USER_UNREPLY.copy().appendKey((Object)virtualUserId);
        Long remove = this.redisHashMapAdapter.remove(unReplyNumKey, new String[]{String.valueOf(realUserId)});
        return remove > 0L;
    }
}

