/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.market.impl;

import com.bxm.localnews.admin.domain.GoldFlowMapper;
import com.bxm.localnews.admin.enums.GoldFlowTypeEnum;
import com.bxm.localnews.admin.param.GoldFlowQueryParam;
import com.bxm.localnews.admin.service.market.GoldFlowService;
import com.bxm.localnews.admin.utils.ExportUtils;
import com.bxm.localnews.admin.utils.dto.ExportDataRow;
import com.bxm.localnews.admin.utils.dto.ExportModel;
import com.bxm.localnews.admin.vo.GoldFlow;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GoldFlowServiceImpl
implements GoldFlowService {
    private static final Logger logger = LoggerFactory.getLogger(GoldFlowServiceImpl.class);
    @Resource
    private GoldFlowMapper goldFlowMapper;

    @Override
    public List<String> getTypeList() {
        ArrayList<String> typeList = new ArrayList<String>();
        for (GoldFlowTypeEnum typeEnum : GoldFlowTypeEnum.values()) {
            typeList.add(typeEnum.getDesc());
        }
        return typeList;
    }

    @Override
    public PageWarper<GoldFlow> getList(GoldFlowQueryParam param) {
        param.setType(GoldFlowTypeEnum.getNameByDesc((String)param.getType()));
        return new PageWarper(this.goldFlowMapper.getList(param));
    }

    @Override
    public void exportExcel(GoldFlowQueryParam param, HttpServletResponse response) {
        param.setPageNum(Integer.valueOf(1));
        param.setPageSize(Integer.valueOf(20000));
        List goldFlowList = this.goldFlowMapper.getList(param);
        try {
            String fileName = "\u7ea2\u82b1\u660e\u7ec6.xls";
            String headNames = "\u6d41\u6c34id,\u7528\u6237id,\u6d41\u6c34\u7c7b\u578b,\u53d8\u66f4\u6570\u91cf,\u53d8\u66f4\u7c7b\u578b,\u521b\u5efa\u65f6\u95f4";
            ExportModel exportModel = new ExportModel();
            exportModel.setHeadNames(headNames);
            ArrayList<ExportDataRow> dataRowList = new ArrayList<ExportDataRow>();
            if (CollectionUtils.isNotEmpty((Collection)goldFlowList)) {
                for (GoldFlow goldFlow : goldFlowList) {
                    ExportDataRow exportDataRow = new ExportDataRow();
                    ArrayList<String> dataColumnList = new ArrayList<String>();
                    dataColumnList.add(goldFlow.getId() + "");
                    dataColumnList.add(goldFlow.getUserId() + "");
                    dataColumnList.add(GoldFlowTypeEnum.getDescByName((String)goldFlow.getType()));
                    dataColumnList.add(goldFlow.getAmount() + "");
                    dataColumnList.add(goldFlow.getAmount() >= 0 ? "\u6536\u5165" : "\u652f\u51fa");
                    dataColumnList.add(DateUtils.formatDateTime((Date)goldFlow.getCreateTime()));
                    exportDataRow.setDataColumnList(dataColumnList);
                    dataRowList.add(exportDataRow);
                }
            }
            exportModel.setDataRowList(dataRowList);
            byte[] result = ExportUtils.makeExcel((ExportModel)exportModel, (String)fileName);
            ExportUtils.exportToResponse((HttpServletResponse)response, (String)fileName, (byte[])result, (String)"excel");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u91d1\u5e01\u6d41\u6c34\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

