/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.security.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.UserBlockMapper;
import com.bxm.localnews.admin.dto.UserBlockDTO;
import com.bxm.localnews.admin.enums.BlockUserTypeEnum;
import com.bxm.localnews.admin.integration.IMIntegrationService;
import com.bxm.localnews.admin.integration.UserAuthCodeIntegrationService;
import com.bxm.localnews.admin.param.RemoveAuthCodeParam;
import com.bxm.localnews.admin.param.security.UserAuthCodeParam;
import com.bxm.localnews.admin.service.security.AdminBlockUserService;
import com.bxm.localnews.admin.vo.UserBlock;
import com.bxm.localnews.auth.enums.AuthCodeEnum;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminBlockUserServiceImpl
implements AdminBlockUserService {
    @Autowired
    private UserBlockMapper userBlockMapper;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private IMIntegrationService imIntegrationService;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private UserAuthCodeIntegrationService userAuthCodeIntegrationService;

    @Override
    public UserBlockDTO getInfo(Long userId) {
        List userBlockList = this.userBlockMapper.selectByUserId(userId);
        if (CollectionUtils.isEmpty((Collection)userBlockList)) {
            return null;
        }
        return this.convert(userId, userBlockList);
    }

    @Override
    public Boolean editUserBlock(UserBlockDTO userBlockDTO) {
        Long userId = userBlockDTO.getUserId();
        Date blockTime = userBlockDTO.getBlockTime();
        ArrayList index = Lists.newArrayList();
        if (userBlockDTO.getChatLimitFlag().booleanValue()) {
            this.limit(userBlockDTO, BlockUserTypeEnum.CHAT_LIMIT, this.getChatLimitRedisKey(userId));
            this.imIntegrationService.block(userId, blockTime);
        } else {
            this.cancelLimit(userBlockDTO, BlockUserTypeEnum.CHAT_LIMIT, this.getChatLimitRedisKey(userId));
            this.imIntegrationService.unblock(userId);
        }
        if (userBlockDTO.getBlockFlag().booleanValue()) {
            this.limit(userBlockDTO, BlockUserTypeEnum.BLOCK_LIMIT, this.getBlockLimitRedisKey(userId));
        } else {
            this.cancelLimit(userBlockDTO, BlockUserTypeEnum.BLOCK_LIMIT, this.getBlockLimitRedisKey(userId));
        }
        if (userBlockDTO.getRecommendLimitFlag().booleanValue()) {
            this.limit(userBlockDTO, BlockUserTypeEnum.RECOMMEND_LIMIT, this.getRecommendLimitRedisKey(userId));
        } else {
            this.cancelLimit(userBlockDTO, BlockUserTypeEnum.RECOMMEND_LIMIT, this.getRecommendLimitRedisKey(userId));
        }
        if (userBlockDTO.getForbidComment().booleanValue()) {
            this.addForbidUserAuth(AuthCodeEnum.FORBID_COMMENT, userBlockDTO.getUserId());
            this.limit(userBlockDTO, BlockUserTypeEnum.FORBID_COMMENT, this.getForbidCommentLimitRedisKey(userId));
            index.add(AuthCodeEnum.FORBID_COMMENT.index);
        } else {
            this.removeForbidUserAuth(AuthCodeEnum.FORBID_COMMENT, userBlockDTO.getUserId());
            this.cancelLimit(userBlockDTO, BlockUserTypeEnum.FORBID_COMMENT, this.getForbidNoteLimitRedisKey(userId));
        }
        if (userBlockDTO.getForbidPost().booleanValue()) {
            this.addForbidUserAuth(AuthCodeEnum.FORBID_POST, userBlockDTO.getUserId());
            this.limit(userBlockDTO, BlockUserTypeEnum.FORBID_POST, this.getForbidPostLimitRedisKey(userId));
            index.add(AuthCodeEnum.FORBID_POST.index);
        } else {
            this.removeForbidUserAuth(AuthCodeEnum.FORBID_POST, userBlockDTO.getUserId());
            this.cancelLimit(userBlockDTO, BlockUserTypeEnum.FORBID_POST, this.getForbidNoteLimitRedisKey(userId));
        }
        if (userBlockDTO.getForbidNote().booleanValue()) {
            this.addForbidUserAuth(AuthCodeEnum.FORBID_NOTE, userBlockDTO.getUserId());
            this.limit(userBlockDTO, BlockUserTypeEnum.FORBID_NOTE, this.getForbidNoteLimitRedisKey(userId));
            index.add(AuthCodeEnum.FORBID_NOTE.index);
        } else {
            this.removeForbidUserAuth(AuthCodeEnum.FORBID_NOTE, userBlockDTO.getUserId());
            this.cancelLimit(userBlockDTO, BlockUserTypeEnum.FORBID_NOTE, this.getForbidNoteLimitRedisKey(userId));
        }
        this.userAuthCodeIntegrationService.removeAuthTask(userBlockDTO.getUserId());
        if (CollectionUtils.isNotEmpty((Collection)index)) {
            RemoveAuthCodeParam param = RemoveAuthCodeParam.builder().authCodeIndex((List)index).expireTime(userBlockDTO.getBlockTime()).userId(userBlockDTO.getUserId()).build();
            this.userAuthCodeIntegrationService.addRemoveAuthTask(param);
        }
        return Boolean.TRUE;
    }

    private void addForbidUserAuth(AuthCodeEnum ennum, Long userId) {
        UserAuthCodeParam param = new UserAuthCodeParam();
        param.setAuthCode(ennum.index);
        param.setUserId(userId);
        this.userAuthCodeIntegrationService.addAuth(param);
    }

    private void removeForbidUserAuth(AuthCodeEnum ennum, Long userId) {
        UserAuthCodeParam param = new UserAuthCodeParam();
        param.setAuthCode(ennum.index);
        param.setUserId(userId);
        this.userAuthCodeIntegrationService.delAuth(param);
    }

    private UserBlockDTO convert(Long userId, List<UserBlock> userBlockList) {
        UserBlockDTO userBlockDTO = UserBlockDTO.builder().userId(userId).blockTime(userBlockList.get(0).getBlockTime()).build();
        userBlockList.forEach(userBlock -> {
            if (BlockUserTypeEnum.CHAT_LIMIT.getBlockType().equals(userBlock.getBlockType()) && StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getChatLimitRedisKey(userId)))) {
                userBlockDTO.setChatLimitFlag(Boolean.valueOf(true));
            }
            if (BlockUserTypeEnum.BLOCK_LIMIT.getBlockType().equals(userBlock.getBlockType()) && StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getBlockLimitRedisKey(userId)))) {
                userBlockDTO.setBlockFlag(Boolean.valueOf(true));
            }
            if (BlockUserTypeEnum.RECOMMEND_LIMIT.getBlockType().equals(userBlock.getBlockType()) && StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getRecommendLimitRedisKey(userId)))) {
                userBlockDTO.setRecommendLimitFlag(Boolean.valueOf(true));
            }
            if (BlockUserTypeEnum.FORBID_COMMENT.getBlockType().equals(userBlock.getBlockType()) && StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getForbidCommentLimitRedisKey(userId)))) {
                userBlockDTO.setForbidComment(Boolean.valueOf(true));
            }
            if (BlockUserTypeEnum.FORBID_POST.getBlockType().equals(userBlock.getBlockType()) && StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getForbidPostLimitRedisKey(userId)))) {
                userBlockDTO.setForbidPost(Boolean.valueOf(true));
            }
            if (BlockUserTypeEnum.FORBID_NOTE.getBlockType().equals(userBlock.getBlockType()) && StringUtils.isNotBlank((CharSequence)this.redisStringAdapter.getString(this.getForbidNoteLimitRedisKey(userId)))) {
                userBlockDTO.setForbidNote(Boolean.valueOf(true));
            }
        });
        return userBlockDTO;
    }

    private void cancelLimit(UserBlockDTO userBlockDTO, BlockUserTypeEnum blockUserTypeEnum, KeyGenerator redisKey) {
        Long userId = userBlockDTO.getUserId();
        UserBlock userBlock = new UserBlock();
        userBlock.setUserId(userId);
        userBlock.setBlockType(blockUserTypeEnum.getBlockType());
        this.userBlockMapper.deleteByUserIdAndType(userBlock);
        if (Objects.nonNull(redisKey)) {
            this.redisStringAdapter.remove(redisKey);
        }
    }

    private void limit(UserBlockDTO userBlockDTO, BlockUserTypeEnum blockUserTypeEnum, KeyGenerator redisKey) {
        Date blockTime = userBlockDTO.getBlockTime();
        this.addRecord(userBlockDTO, blockUserTypeEnum.getBlockType());
        this.redisStringAdapter.set(redisKey, (Object)blockTime);
        this.redisStringAdapter.expire(redisKey, blockTime);
    }

    private void addRecord(UserBlockDTO userBlockDTO, Integer blockType) {
        UserBlock userBlock = UserBlock.builder().id(this.sequenceCreater.nextLongId()).userId(userBlockDTO.getUserId()).blockTime(userBlockDTO.getBlockTime()).blockType(blockType).build();
        this.userBlockMapper.deleteByUserIdAndType(userBlock);
        this.userBlockMapper.insertSelective(userBlock);
    }

    private KeyGenerator getChatLimitRedisKey(Long userId) {
        return RedisConfig.IM_BLOCK_LIST.copy().appendKey((Object)userId);
    }

    private KeyGenerator getBlockLimitRedisKey(Long userId) {
        return RedisConfig.USER_BLOCK_LIMIT.copy().appendKey((Object)userId);
    }

    private KeyGenerator getRecommendLimitRedisKey(Long userId) {
        return RedisConfig.RECOMMEND_BLOCK_LIMIT.copy().appendKey((Object)userId);
    }

    private KeyGenerator getForbidCommentLimitRedisKey(Long userId) {
        return RedisConfig.FORBID_COMMENT_LIMIT.copy().appendKey((Object)userId);
    }

    private KeyGenerator getForbidPostLimitRedisKey(Long userId) {
        return RedisConfig.FORBID_POST_LIMIT.copy().appendKey((Object)userId);
    }

    private KeyGenerator getForbidNoteLimitRedisKey(Long userId) {
        return RedisConfig.FORBID_NOTE_LIMIT.copy().appendKey((Object)userId);
    }
}

