package com.bxm.localnews.admin.convert.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bxm.localnews.admin.param.VirtualUserInfoParam;
import com.bxm.localnews.admin.service.base.CommonDictService;
import com.bxm.localnews.admin.service.base.LocationService;
import com.bxm.localnews.admin.vo.Location;
import com.bxm.localnews.admin.vo.VirtualUser;
import com.bxm.newidea.component.tools.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;

@Component
public class VirtualUserInfoConverter extends AbstractConverter<VirtualUserInfoParam, VirtualUser> {


    @Autowired
    private CommonDictService commonDictService;
    @Autowired
    private LocationService locationService;

    @Override
    public VirtualUser convert(VirtualUserInfoParam data) {
        VirtualUser user = new VirtualUser();
        user.setId(data.getId());
        user.setNickname(data.getNickname());
        user.setHeadImg(data.getHeadImg());
        user.setSex(data.getSex());
        user.setCreateTime(new Date());
        user.setModifyTime(new Date());
        user.setBirthday(data.getBirthday());
        user.setAddress(data.getAddress());
        user.setRemark(data.getRemark());
        user.setType(data.getType());
        user.setState(data.getState());
        user.setAgeGroup(data.getAgeGroup());
        user.setMarry(data.getMarry());
        user.setHouse(data.getHouse());
        user.setWork(data.getWork());
        user.setGlobalStatus(data.getGlobalStatus());
        user.setAreaCode(data.getAreaCode());
        // 行业信息
        user.setJobTitle(data.getJobTitle());
        user.setCompany(data.getCompany());
        if (null != data.getJobType() && null != data.getJobCategory()) {
            user.setJobType(data.getJobType());
            user.setJobCategory(data.getJobCategory());
            user.setJobTypeName(commonDictService.getById(data.getJobType()).getLabel());
            user.setJobCategoryName(commonDictService.getById(data.getJobCategory()).getLabel());
        }

        //家乡
        if (StringUtils.isNotBlank(data.getProvinceCode()) && StringUtils.isNotBlank(data.getCityCode())
                && StringUtils.isNotBlank(data.getCountyCode())) {
            Map<String, Location> locationMap = locationService.listLocation();
            if (MapUtils.isNotEmpty(locationMap) && null != locationMap.get(data.getCountyCode())) {
                user.setHometownName(locationMap.get(data.getCountyCode()).getFullName());
            }
            user.setHometownCode(data.getProvinceCode() + "_" + data.getCityCode() + "_" + data.getCountyCode());
        }
        // 兴趣标签
        if (CollectionUtils.isNotEmpty(data.getUserTagIds())){
            user.setHobby(JSONObject.toJSONString(data.getUserTagIds(), SerializerFeature.WriteNullListAsEmpty));
        }
        user.setPersonalProfile(data.getPersonalProfile());

        return user;
    }
}
