package com.bxm.localnews.admin.service.activity;

import com.bxm.localnews.admin.dto.AdvertDTO;
import com.bxm.localnews.admin.param.AdvertParam;
import com.bxm.localnews.admin.vo.Advert;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * @author zhaoyadong 2018/10/19 14:42
 * @desc
 */
public interface AdminAdvertService {

    /**
     * 查询广告
     * @param advertParam 广告参数
     * @return 分页结果
     */
    PageWarper<AdvertDTO> getAdvertList(AdvertParam advertParam);

    /**
     * 广告详情
     * @param id
     * @return
     */
    AdvertDTO getAdvertById(Long id);

    /**
     * 批量更新活动状态
     * @param ids
     * @param status
     * @return 更新的行数
     */
    int updateAdvertStatusById(String[] ids, Byte status);

    /**
     * 更新活动状态
     * @param id
     * @param status
     * @return 更新的行数
     */
    int updateAdvertStatusById(Long id, Byte status);

    /**
     * 新增或编辑广告
     * @param advert
     * @param areaCodes 地区编码
     * @return
     */
    int addAdvertDetail(Advert advert, String areaCodes);

    /**
     * 删除广告
     * @param id
     * @return
     */
    int deleteAdvert(Long id);

    /**
     * 获取广告类型的最大权重值
     * @param type
     * @return
     */
    int getMaxOrderByType(Byte type);
}
