package com.bxm.localnews.admin.service.activity.impl;

import com.bxm.localnews.admin.domain.AdminActivityMapper;
import com.bxm.localnews.admin.param.ActivityParam;
import com.bxm.localnews.admin.service.activity.AdminActivityService;
import com.bxm.localnews.admin.vo.Activity;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminActivityServiceImpl implements AdminActivityService {

    private AdminActivityMapper adminActivityMapper;

    @Autowired
    public AdminActivityServiceImpl(AdminActivityMapper adminActivityMapper) {
        this.adminActivityMapper = adminActivityMapper;
    }

    @Override
    public PageWarper<Activity> queryActivitys(ActivityParam param) {
        Preconditions.checkArgument(param != null);

        return new PageWarper<>(adminActivityMapper.queryActivityByPageSize(param));
    }

    @Override
    public int updateActivityStateByIds(String[] ids, Byte state) {
        return this.adminActivityMapper.updateActivityStateByIds(ids, state);
    }

    @Override
    public Activity selectByPrimaryKey(Long id) {
        return this.adminActivityMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(Activity record) {
        return this.adminActivityMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int insertSelective(Activity record) {
        return this.adminActivityMapper.insertSelective(record);
    }
}
