package com.bxm.localnews.admin.service.activity.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.admin.common.DingtalkProperties;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.convert.impl.SendCashConvert;
import com.bxm.localnews.admin.convert.impl.SendFlowConvert;
import com.bxm.localnews.admin.domain.UserAccountGrantFlowMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.dto.CashDTO;
import com.bxm.localnews.admin.entry.UserAccountGrantFlow;
import com.bxm.localnews.admin.enums.CashEnum;
import com.bxm.localnews.admin.enums.CashFlowTypeEnum;
import com.bxm.localnews.admin.enums.UserGrantChangeTypeEnum;
import com.bxm.localnews.admin.enums.UserGrantFlowTypeEnum;
import com.bxm.localnews.admin.integration.UserAccountIntegrationService;
import com.bxm.localnews.admin.param.*;
import com.bxm.localnews.admin.service.activity.GiveOutCashService;
import com.bxm.localnews.admin.service.activity.UserAccountGrantFlowService;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author: gengyy
 * @create: 2020-10-21 18:31
 */
@Service
@AllArgsConstructor
public class GiveOutCashServiceImpl extends BaseService implements GiveOutCashService {

    private final SendCashConvert sendCashConvert;

    private final UserMapper userMapper;

    private final UserAccountGrantFlowMapper userAccountGrantFlowMapper;

    private final MessageSender messageSender;

    private final UserAccountIntegrationService userAccountIntegrationService;

    private final HttpClientService httpClientService;

    private final DingtalkProperties dingtalkProperties;

    private final UserAccountGrantFlowService userAccountGrantFlowService;

    private final RedisStringAdapter redisStringAdapter;

    @Override
    public Long getUniquelyId() {
        return this.nextId();
    }

    @Override
    public CashDTO doSendCash(CashParam cashParam, AdminUser adminUser) {
        CashDTO result = new CashDTO();
        List<BaseCashParam.UserCash> userCashes = sendCashConvert.convert(cashParam);
        //校验用户是否存在,用户有不存在信息,直接返回
        List<Long> notExitIds = checkUserExits(userCashes);
        if (CollectionUtils.isNotEmpty(notExitIds)) {
            result.setSuccessCode(1);
            result.setNotExitIds(notExitIds);
        } else {
            grantCashAction(userCashes, cashParam, result, adminUser);
        }
        return result;
    }

    private CashDTO grantCashAction(List<BaseCashParam.UserCash> userCashes, CashParam cashParam, CashDTO result, AdminUser adminUser) {
        double cashNum = userCashes.stream().mapToDouble(BaseCashParam.UserCash::getCashNum).sum();
        if (cashNum < 1000) {
            sendCash(userCashes, cashParam, result, adminUser);
        } else {
            //获得验证码
            String verifyCode = redisStringAdapter.getString(getVerifyCodeKey(cashParam));
            if (StringUtils.isNotBlank(verifyCode)) {
                //前端验证码不为空时校验
                if (StringUtils.isNotBlank(cashParam.getVerifyCode())) {
                    if (verifyCode.equalsIgnoreCase(cashParam.getVerifyCode())) {
                        //发放现金
                        sendCash(userCashes, cashParam, result, adminUser);
                        //清除验证码
                        redisStringAdapter.remove(getVerifyCodeKey(cashParam));
                    } else {
                        //验证码错误
                        result.setSuccessCode(3);
                    }
                } else {
                    result.setSuccessCode(2);
                }

            } else {
                //发送验证码
                sendVerifyCode(cashParam, cashNum, userCashes.size());
                result.setSuccessCode(2);
            }
        }
        return result;
    }

    private void sendVerifyCode(CashParam cashParam, double cashNum, int peopleNum) {
        String verifyCode = RandomStringUtils.random(4, false, true);
        StringBuilder content = new StringBuilder();
        content.append("【现金发放验证码:")
                .append(verifyCode).append(",总计").append(cashNum)
                .append("现金, 共").append(peopleNum).append("人 ")
                .append("，备注：").append(cashParam.getRemake() == null ? "" : cashParam.getRemake()).append("】");
        JSONObject text = new JSONObject();
        text.put("content", content);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);
        String response = httpClientService.doPostJson(dingtalkProperties.getVerifyCodeWebhook(), msg.toJSONString());
        logger.debug("dingding response:{}", response);
        redisStringAdapter.set(getVerifyCodeKey(cashParam), verifyCode, 900);
    }

    /**
     * 获得验证码key
     *
     * @param cashParam
     * @return
     */
    private KeyGenerator getVerifyCodeKey(CashParam cashParam) {
        KeyGenerator flowerKey = RedisConfig.GRANT_CASH_FLOWER.copy();
        BaseFlowerParam param = new BaseFlowerParam();
        BeanUtils.copyProperties(cashParam, param);
        int code = param.hashCode();
        KeyGenerator keyGenerator = flowerKey.appendKey(code);
        return keyGenerator;
    }

    private void sendCash(List<BaseCashParam.UserCash> userCashes, CashParam cashParam, CashDTO result, AdminUser adminUser) {
        String url = "wst://mine/totalEarnings";
        userCashes.stream().forEach(e -> {
            BigDecimal cash = BigDecimal.valueOf(e.getCashNum()).setScale(2, BigDecimal.ROUND_DOWN);
            //给用户添加现金
            AccountCashParam param = new AccountCashParam();
            //传递流水类型展示文本  这个字段为红花商城明细的标题，即后台写入的流水类型
            param.setContent(cashParam.getFlowType());
            param.setUserId(e.getUserId());
            param.setCash(cash);
            param.setAddTotal(true);
            param.setCashType(CashEnum.DRAWABLEL_CASH.name());
            param.setCashFlowType(CashFlowTypeEnum.OTHER.getName());
            //这个字段为我的收益展示列表每条信息的标题 ，即后台写入的流水类型
            param.setRemake(cashParam.getFlowType());
            userAccountIntegrationService.addCash(param);

            PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
            info.addExtend("msgId", nextId());
            info.addExtend("url", url);
            PushMessage message = PushMessage.build();
            message.setTitle(cashParam.getFlowType());
            message.setContent(cashParam.getContent());
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle(e.getUserId()));
            message.setPayloadInfo(info);
            messageSender.sendPushMessage(message);

            UserAccountGrantFlow userAccountGrantFlow = new UserAccountGrantFlow();
            userAccountGrantFlow.setType(UserGrantFlowTypeEnum.CASH.getType());
            userAccountGrantFlow.setChangeType(UserGrantChangeTypeEnum.INCOME.getType());
            userAccountGrantFlow.setId(getUniquelyId());
            userAccountGrantFlow.setUserId(e.getUserId());
            userAccountGrantFlow.setRemake(cashParam.getRemake());
            userAccountGrantFlow.setCashAmount(cash);
            userAccountGrantFlow.setContent(cashParam.getContent());
            userAccountGrantFlow.setFlowType(cashParam.getFlowType());
            userAccountGrantFlow.setCreateTime(new Date());
            userAccountGrantFlow.setOperatorId(adminUser.getId());
            userAccountGrantFlow.setOperatorName(adminUser.getName());
            userAccountGrantFlowMapper.insertSelective(userAccountGrantFlow);
        });
        result.setSuccessCode(0);
    }

    /**
     * 判断用户是否存在
     *
     * @param userFlowers
     * @return
     */
    private List<Long> checkUserExits(List<BaseCashParam.UserCash> userFlowers) {
        List<Long> result = Lists.newArrayList();
        userFlowers.forEach(e -> {
            User user = userMapper.selectByUserId(e.getUserId());
            if (Objects.isNull(user) || user.getState() != 1) {
                result.add(e.getUserId());
            }
        });
        return result;
    }

    @Override
    public PageWarper<UserAccountGrantFlow> listFlower(UserAccountGrantFlowParam pageParam) {
        pageParam.setType(UserGrantFlowTypeEnum.CASH.getType());
        return new PageWarper<UserAccountGrantFlow>(userAccountGrantFlowService.listFlower(pageParam));
    }
}
