package com.bxm.localnews.admin.service.activity.strategy;

import com.bxm.localnews.admin.common.BizConfigProperties;
import com.bxm.localnews.admin.vo.AreaPushCode;
import com.bxm.newidea.component.CodeCreaterFactory;
import com.bxm.newidea.component.param.QrCodeParam;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;

import static org.apache.commons.io.FileUtils.copyURLToFile;

/**
 * @author zhaoyadong 2019/4/2 17:30
 * @desc
 */

@RefreshScope
public abstract class AbstractPushCodeService extends BaseService implements PushCodeService {

    @Autowired
    private BizConfigProperties bizConfigProperties;

    @Override
    public Message execPushCode(AreaPushCode areaPushCode, String codeUrl) {
        Message message = Message.build();
        return message.addParam("file", generateQrcode(areaPushCode, codeUrl));
    }

    /**
     * 生成二维码
     * @return
     */
    abstract File generateQrcode(AreaPushCode areaPushCode, String codeUrl);

    /**
     * 根据推广码id生成二维码
     * @param code
     * @return
     * @throws IOException
     */
    File gen(String code, String url, int width, int height) throws IOException {
        String rootPath = getRootPath();


        //创建二维码
        File qrCodeFile = new File(rootPath + code + ".jpg");
        QrCodeParam param = new QrCodeParam();
        param.setWidth(width);
        param.setHeight(height);
        param.setImageFile(qrCodeFile);
        param.setMessage(url);
        param.setLogoPath(getIconFile().getPath());
        CodeCreaterFactory.createQrCode(param);

        //删除文件
//        qrCodeFile.delete();

        return qrCodeFile;
    }

    File genPushCode(File qrcodeFile, String code, String templateUrl, int x, int y) throws IOException {
        String suffix = "png";

        String finalFileName = code + "_final." + suffix;
        File finalFile = new File(getRootPath() + finalFileName);
        BufferedImage finalImgBuffer = watermark(getSourceFile(templateUrl), qrcodeFile, x, y, 1);
        ImageIO.write(finalImgBuffer, suffix, finalFile);
        qrcodeFile.delete();
        return finalFile;
    }

    /**
     * 根据url获取文件
     * @param url
     * @return
     */
    File getSourceFile(String url) {
        return getAliyunOssFile(url);
    }


    String getRootPath() {
        return bizConfigProperties.getTempDir() + File.separator;
    }

    /**
     * 获取logo文件
     * @return
     */
    File getIconFile() {
        return getAliyunOssFile(bizConfigProperties.getAppIconUrl());
    }

    File getAliyunOssFile(String aliyunFilePath) {
        String fileName = StringUtils.substringAfterLast(aliyunFilePath, "/");

        String separator = StringUtils.EMPTY;
        if (!this.bizConfigProperties.getTempDir().endsWith("/") &&
                !this.bizConfigProperties.getTempDir().endsWith("\\")) {
            separator = File.separator;
        }

        File appFile = new File(this.bizConfigProperties.getTempDir() + separator + fileName);

        if (appFile.exists()) {
            return appFile;
        }

        File tempDirFile = new File(this.bizConfigProperties.getTempDir());
        if (!tempDirFile.exists()) {
            boolean result = tempDirFile.mkdirs();
            if (!result) {
                this.logger.error("创建[{}]目录失败，可能没有权限", this.bizConfigProperties.getTempDir());
            }
        }

        try {
            copyURLToFile(new URL(aliyunFilePath), appFile);
        } catch (IOException e) {
            this.logger.error(aliyunFilePath + "配置的下载文件路径不正确", e);
        }

        return appFile;
    }


    /**
     * @param file      源文件(图片)
     * @param waterFile 水印文件(图片)
     * @param x         距离左上角的X偏移量
     * @param y         距离左上角的Y偏移量
     * @param alpha     透明度, 选择值从0.0~1.0: 完全透明~完全不透明
     * @return BufferedImage
     * @throws IOException
     */
    BufferedImage watermark(File file, File waterFile, int x, int y, float alpha) throws IOException {
        // 获取底图
        BufferedImage buffImg = ImageIO.read(file);
        // 获取层图
        BufferedImage waterImg = ImageIO.read(waterFile);
        // 创建Graphics2D对象，用在底图对象上绘图
        Graphics2D g2d = buffImg.createGraphics();
        // 获取层图的宽度
        int waterImgWidth = waterImg.getWidth();
        // 获取层图的高度
        int waterImgHeight = waterImg.getHeight();
        // 在图形和图像中实现混合和透明效果
        g2d.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_ATOP, alpha));
        // 绘制
        g2d.drawImage(waterImg, x, y, waterImgWidth, waterImgHeight, null);
        g2d.dispose();// 释放图形上下文使用的系统资源
        return buffImg;
    }
}
