package com.bxm.localnews.admin.service.base;

import com.bxm.localnews.admin.dto.AreaDivisionDTO;
import com.bxm.localnews.admin.dto.AreaDivisionDetailDTO;

import java.util.List;

/**
 * 地区规划相关接口
 */
public interface AreaDivisionService {

    /**
     * 用途：根据父级编号获得省市区街道地址,当parentCode为空时获取最上级的省份信息
     * @param parentCode
     * @return
     */
    List<AreaDivisionDTO> listAreaDivisionDTO(String parentCode);

    /**
     * 用途：根据编号取得省市区街道详细信息
     * @param code
     * @return
     */
    AreaDivisionDetailDTO getAreaDivisionDTO(String code);

}
