package com.bxm.localnews.admin.service.base;


import com.bxm.localnews.admin.dto.LocationDTO;
import com.bxm.localnews.admin.param.*;
import com.bxm.localnews.admin.vo.Location;
import com.bxm.localnews.admin.vo.LocationOfficialAccountVO;
import com.bxm.localnews.admin.vo.LocationPhoneVO;
import com.bxm.newidea.component.vo.ResponseJson;

import java.util.List;
import java.util.Map;

/**
 * 地区相关接口
 */
public interface LocationService {

    /**
     * 分页查询所有城市
     * @param locationParam
     * @return
     */
    List<LocationDTO> listLocationByPage(LocationPageParam locationParam);

    /**
     * 用途：显示所有平铺城市
     * @param locationParam
     * @return
     */
    List<LocationDTO> listLocation(LocationParam locationParam);

    /**
     * 编辑城市信息
     * @param param
     * @return
     */
    ResponseJson modifyLocation(ModifyLocationParam param);

    /**
     * 用途：根据编号新增热门城市
     * @param code
     */
    void saveHotLocation(String code);

    /**
     * 热门城市
     * @return
     */
    List<LocationDTO> listHotLocation();

    /**
     * 用途：根据编号新增已开通城市
     * @param code
     */
    void saveOpenedLocation(String code);

    /**
     * 用途：根据城市编号查询该城市下的已开通城市  省->市->市或县
     * @param code
     * @return
     */
    List<LocationDTO> listOpenedLocationByArea(String code, Byte show);

    /**
     * 用途：根据城市编号查询该城市下的已开通城市 省->市或县
     * @param code
     * @return
     */
    List<LocationDTO> listOpenedLocationByAreaWithTwoLevels(String code, Byte show);

    /**
     * 获取所有城市，缓存在内存中
     * @return
     */
    Map<String,Location> listLocation();

    /**
     * 根据地区编号列表获得地区的json串信息
     * @param areaDetailArray
     * @return
     */
    String getAreaDetail(String[] areaDetailArray);

    /**
     * 根据区域编码列表获取地区信息列表
     * @param areaCodes
     * @return
     */
    List<Location> getLocationsByAreaCodes(List<String> areaCodes);

    /**
     * 保存绑定关联关系
     * @param param ： 关联关系信息
     * @return 是否成功
     */
    Boolean saveLocationRelation(LocationRelationParam param);

    /**
     * 修改绑定关联关系
     * @param param ： 关联关系信息
     * @return 是否成功
     */
    Boolean updateLocationRelation(LocationRelationParam param);

    /**
     * 更新所属地区的客服电话
     * @param param 客服电话信息
     * @return 是否成功
     */
    Boolean updateLocationPhone(AreaCustomerPhoneParam param);

    /**
     * 获取所属地区的客服电话通过地区编码
     * @param code
     * @return
     */
    LocationPhoneVO getLocationPhoneByCode(String code);

    boolean updateOfficialAccount(AreaOfficialAccountParam param);

    LocationOfficialAccountVO getOfficialAccountByCode(String code);
}
