package com.bxm.localnews.admin.service.base;

import com.bxm.localnews.admin.dto.ChannelInfoDetailDTO;
import com.bxm.localnews.admin.dto.UserChannelDTO;
import com.bxm.localnews.admin.param.UserChannelParam;
import com.bxm.localnews.admin.vo.LocationChannelBean;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;


/**
 * @author : jieli.xu
 * @date 2020/6/18 17:27
 */
public interface UserChannelService {
    /**
     * 新增
     *
     * @param channelInfoDetailDTO ： 栏目信息
     * @return
     */
    Boolean insert(ChannelInfoDetailDTO channelInfoDetailDTO);

    /**
     * 获取栏目信息
     *
     * @param userChannelParam
     * @return
     */
    PageWarper<UserChannelDTO> getList(UserChannelParam userChannelParam);

    /**
     * 获取详情
     *
     * @param userChannelParam
     * @return
     */
    ChannelInfoDetailDTO getDetail(UserChannelParam userChannelParam);

    /**
     * 更新状态 ： 如果之前是上架，这次就改下架。反之亦然
     *
     * @return
     */
    Boolean updateStatus(UserChannelParam userChannelParam);

    /**
     * 更改信息
     *
     * @return
     */
    Boolean update(ChannelInfoDetailDTO channelInfoDetailDTO);

    /**
     * 获取可用的栏目列表
     *
     * @return 栏目列表
     */
    List<LocationChannelBean> getEnableList();
}
