package com.bxm.localnews.admin.service.base;

import java.util.List;
import java.util.Map;

import com.bxm.localnews.admin.dto.AdminVirtualUserDTO;
import com.bxm.localnews.admin.dto.ChatVirtualUserDTO;
import com.bxm.localnews.admin.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.admin.param.VirtualUserInfoParam;
import com.bxm.localnews.admin.param.VirtualUserParam;
import com.bxm.localnews.admin.param.VirtualUserQueryParam;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.VirtualUser;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.newidea.component.vo.PageWarper;

public interface VirtualUserService {

    /**
     * 用途：保存马甲号信息，如果id有值，则更新该id下的马甲号信息
     *
     * @param virtualUser
     */
    Long save(VirtualUserInfoParam virtualUser,AdminUser loginUser);

    /**
     * 用途：分页获取马甲号的信息
     *
     * @param virtualUserParam
     */
    PageWarper<AdminVirtualUserDTO> listByPage(VirtualUserParam virtualUserParam);

    /**
     * 用途：按某种策略获取马甲号的信息
     *
     * @param virtualUserQueryParam
     */
    List<VirtualUserOverviewDTO> list(VirtualUserQueryParam virtualUserQueryParam);

    /**
     * 根据id获取马甲号详情
     *
     * @param id
     * @return
     */
    VirtualUser getVirtualUserDetail(Long id);

    /**
     * 获取全部马甲号用户
     * @return
     */
    Map<Long,VirtualUser> list();

    /**
     * 更换马甲号管控账号
     * @param virtualUserId
     * @param adminUserId
     * @param loginUser
     * @return
     */
    Boolean changeVestControl(Long virtualUserId, Long adminUserId, AdminUser loginUser,Byte appShow);

    /**
     * 获得运营管控账号列表
     * @param loginUser
     * @return
     */
    List<ChatVirtualUserDTO> getVirtualList(AdminUser loginUser);

    /**
     *
     * @param keyWord 关键字
     * @return
     */
    List<User> getUserByKeyWord(String keyWord);
}
