package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.domain.UserCommonTagMapper;
import com.bxm.localnews.admin.service.base.UserCommonTagService;
import com.bxm.localnews.admin.vo.UserCommonTag;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.stream.Collectors;

@Service
@Log4j2
public class UserCommonTagServiceImpl implements UserCommonTagService {

    @Autowired
    private UserCommonTagMapper userCommonTagMapper;

    @Override
    @Cacheable(value = "userCommonTagMap", sync = true)
    public Map<Long, UserCommonTag> getUserCommonTagMap() {
        // 获取所有用户标签
        return userCommonTagMapper.listAll().stream().collect(Collectors.toMap(UserCommonTag::getId,userCommonTag -> userCommonTag));
    }
}
