package com.bxm.localnews.admin.service.market;

import com.bxm.localnews.admin.param.GoldFlowQueryParam;
import com.bxm.localnews.admin.vo.GoldFlow;
import com.bxm.newidea.component.vo.PageWarper;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 金币流水服务
 */
public interface GoldFlowService {

    /**
     * 流水类型查询
     *
     * @return
     */
    List<String> getTypeList();

    /**
     * 查询金币流水
     *
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<GoldFlow> getList(GoldFlowQueryParam param);

    /**
     * 导出excel
     *
     * @param param
     * @param response
     */
    void exportExcel(GoldFlowQueryParam param, HttpServletResponse response);
}
