package com.bxm.localnews.admin.service.market;

import com.bxm.localnews.admin.param.MarketCommodityQueryParam;
import com.bxm.localnews.admin.vo.MarketCommodity;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 商品管理服务
 */
public interface MarketCommodityService {

    /**
     * 查询商品
     *
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<MarketCommodity> getList(MarketCommodityQueryParam param);

    /**
     * 获取商品详情
     *
     * @param id
     * @return
     */
    MarketCommodity selectByPrimaryKey(Long id);

    /**
     * 商品上下架
     *
     * @param id
     * @param status
     * @return 更新信息
     */
    int updateStatus(Long id, Byte status);

    /**
     * 新增或编辑商品
     *
     * @param marketCommodity
     * @return
     */
    int saveOrUpdate(MarketCommodity marketCommodity);

    /**
     * 修改商品权重
     *
     * @param id
     * @param order
     * @return
     */
    int updateOrder(Long id, Integer order);

    /**
     * 删除商品
     *
     * @param id
     * @param deletor
     * @return
     */
    int deleteById(Long id, Long deletor);
}
