package com.bxm.localnews.admin.service.market.impl;


import com.bxm.localnews.admin.domain.MarketCommodityMapper;
import com.bxm.localnews.admin.param.MarketCommodityQueryParam;
import com.bxm.localnews.admin.service.market.MarketCommodityService;
import com.bxm.localnews.admin.vo.MarketCommodity;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

@Service
public class MarketCommodityServiceImpl implements MarketCommodityService {

    @Resource
    private MarketCommodityMapper marketCommodityMapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public PageWarper<MarketCommodity> getList(MarketCommodityQueryParam param) {
        return new PageWarper<>(marketCommodityMapper.getList(param));
    }

    @Override
    public MarketCommodity selectByPrimaryKey(Long id) {
        return marketCommodityMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateStatus(Long id, Byte status) {
        MarketCommodity marketCommodity = marketCommodityMapper.selectByPrimaryKey(id);
        if (null == marketCommodity) {
            return 0;
        }
        marketCommodity.setStatus(status);
        return marketCommodityMapper.updateByPrimaryKeySelective(marketCommodity);
    }

    @Override
    public int saveOrUpdate(MarketCommodity marketCommodity) {
        int update;
        Long id = marketCommodity.getId();

        if (null == id) {
            id = sequenceCreater.nextLongId();
            marketCommodity.setId(id);
            marketCommodity.setCreateTime(new Date());
            update = marketCommodityMapper.insert(marketCommodity);
        } else {
            update = marketCommodityMapper.updateByPrimaryKeySelective(marketCommodity);
        }

        return update;
    }

    @Override
    public int updateOrder(Long id, Integer order) {
        MarketCommodity marketCommodity = marketCommodityMapper.selectByPrimaryKey(id);
        if (null == marketCommodity) {
            return 0;
        }
        marketCommodity.setOrder(order);
        return marketCommodityMapper.updateByPrimaryKeySelective(marketCommodity);
    }

    @Override
    public int deleteById(Long id, Long deletor) {
        MarketCommodity marketCommodity = marketCommodityMapper.selectByPrimaryKey(id);
        if (null == marketCommodity) {
            return 0;
        }
        marketCommodity.setDeleteFlag((byte) 1);
        marketCommodity.setDeletor(deletor);
        marketCommodity.setDeleteTime(new Date());
        return marketCommodityMapper.updateByPrimaryKeySelective(marketCommodity);
    }

}
