package com.bxm.localnews.admin.service.security;

import com.bxm.localnews.admin.dto.AdminUserDTO;
import com.bxm.localnews.admin.dto.OrderInfoDTO;
import com.bxm.localnews.admin.param.AdminUserParam;
import com.bxm.localnews.admin.param.UserActivationCardParam;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 管理员用户账号管理接口
 *
 * @author liujia 2018/8/7 22:48
 */
public interface AdminUserService {

    /**
     * 获取用户信息缓存
     *
     * @param userName 用户名
     * @return 用户信息，如果缓存中存在则直接返回缓存结果
     */
    AdminUser getUser(String userName);

    /**
     * 清除用户token，使其强制重新登录
     *
     * @param userId 用户ID
     */
    void removeToken(Long userId);

    /**
     * 添加用户token缓存
     *
     * @param userId 用户ID
     * @param token  登录后的token值
     */
    void addTokenCache(Long userId, String token);

    /**
     * 更新用户密码信息
     *
     * @param param 更新参数
     * @return 更新结果
     */
    Json modifyPassword(AdminUserDTO param);

    /**
     * 更新用户密码信息
     *
     * @param param 更新参数
     * @return 更新结果
     */
    Json modifyPasswordByAdmin(AdminUserDTO param);

    Boolean editUserPassWord(AdminUser sysUser);

    /**
     * 用户列表
     *
     * @param adminUserParam
     * @return 分页结果
     */
    PageWarper<AdminUserDTO> queryAdminUsers(AdminUserParam adminUserParam);

    /**
     * 根据用户名查询用户信息
     *
     * @param username
     * @return
     */
    AdminUser selectByUsername(String username);

    /**
     * 添加用户信息
     *
     * @param user
     * @return
     */
    int upsert(AdminUserDTO user);

    /**
     * 更新用户信息
     *
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(AdminUser record);

    /**
     * 根据id获取用户信息
     *
     * @param id
     * @return
     */
    AdminUser selectById(Long id);

    Message updateUserRole(Long userId, Integer roleId);

    List<AdminUserDTO> getAvailableAdminUser();

    /**
     * 分页查询：开卡管理列表
     *
     * @param userActivationCardParam 前端传参
     * @return 列表数据
     */
    PageWarper<OrderInfoDTO> getOpenCardPageList(UserActivationCardParam userActivationCardParam);
}
