package com.bxm.localnews.admin.service.security;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.common.SecurityConfigurationProperties;
import com.bxm.localnews.admin.vo.security.AdminUser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * jwt token操作工具
 */
@Component
@Slf4j
public class JwtTokenService implements Serializable {

    private static final long serialVersionUID = -3301605591108950415L;

    private static final String CLAIM_KEY_USERNAME = "sub";

    private static final String CLAIM_KEY_CREATED = "created";

    private final SecurityConfigurationProperties properties;

    @Autowired
    public JwtTokenService(SecurityConfigurationProperties properties) {
        this.properties = properties;
    }

    /**
     * 创建token过期时间
     */
    private Date generateExpirationDate() {
        return new Date(System.currentTimeMillis() + properties.getJwtTokenExpiration() * 1000);
    }

    /**
     * 通过用户信息创建token
     */
    public String generateToken(AdminUser userDetails) {
        Map<String, Object> claims = new HashMap<>();
        claims.put(CLAIM_KEY_USERNAME, userDetails.getId());
        claims.put(CLAIM_KEY_CREATED, new Date());
        String token = this.generateToken(claims);

        log.debug("创建token，用户信息：{},token:{}", JSON.toJSONString(userDetails), token);

        return token;
    }

    private String generateToken(Map<String, Object> claims) {
        return Jwts.builder()
                .setClaims(claims)
                .setExpiration(this.generateExpirationDate())
                .signWith(SignatureAlgorithm.HS512, properties.getJwtSecret())
                .compact();
    }
}