package com.bxm.localnews.admin.service.security.impl;

import com.bxm.localnews.admin.domain.auth.UserRoleMapper;
import com.bxm.localnews.admin.dto.UserManageDTO;
import com.bxm.localnews.admin.integration.UserAuthCodeIntegrationService;
import com.bxm.localnews.admin.param.UserManageParam;
import com.bxm.localnews.admin.param.security.UserRoleParam;
import com.bxm.localnews.admin.service.security.ManageUserAdminInfoService;
import com.bxm.localnews.admin.vo.Message;
import com.bxm.localnews.admin.vo.auth.UserRoleBean;
import com.bxm.localnews.auth.enums.RoleCodeEnum;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @author gonzo
 * @date 2020-09-24 15:18
 **/
@Slf4j
@Service
@AllArgsConstructor
public class ManageUserAdminInfoServiceImpl implements ManageUserAdminInfoService {

    private final UserRoleMapper userRoleMapper;

    private final UserAuthCodeIntegrationService userAuthCodeIntegrationService;

    @Override
    public UserManageDTO getAdminInfo(Long userId) {

        List<UserRoleBean> userRoles = userRoleMapper.queryUserRoles(Collections.singletonList(userId));
        UserManageDTO manageDTO = new UserManageDTO();
        manageDTO.setUserId(userId);
        manageDTO.setForumManageFlag(userRoles.stream().anyMatch(p -> Objects.equals(p.getRoleCode(), RoleCodeEnum.FORUM_ADMIN.name())));
        manageDTO.setChatRoomAdminFlag(userRoles.stream().anyMatch(p -> Objects.equals(p.getRoleCode(), RoleCodeEnum.CHAT_ROOM_ADMIN.name())));
        manageDTO.setVirtualManageFlag(userRoles.stream().anyMatch(p -> Objects.equals(p.getRoleCode(), RoleCodeEnum.VIRTUAL_ADMIN.name())));

        return manageDTO;
    }

    @Override
    public Message editAdminInfo(UserManageParam param) {
        List<UserRoleBean> userRoles = userRoleMapper.queryUserRoles(Collections.singletonList(param.getUserId()));

        if (userRoles.stream().anyMatch(p -> Objects.equals(p.getRoleCode(), RoleCodeEnum.CHAT_ROOM_ADMIN.name()))) {
            // 原本有聊天室权限
            if (!Objects.equals(param.getChatRoomAdminFlag(), Boolean.TRUE)) {
                // 移除权限
                userAuthCodeIntegrationService.removeRole(build(param.getUserId(), RoleCodeEnum.CHAT_ROOM_ADMIN.name()));
            }
        } else {
            // 原本没有
            if (Objects.equals(param.getChatRoomAdminFlag(), Boolean.TRUE)) {
                // 添加权限
                userAuthCodeIntegrationService.addRole(build(param.getUserId(), RoleCodeEnum.CHAT_ROOM_ADMIN.name()));
            }
        }

        if (userRoles.stream().anyMatch(p -> Objects.equals(p.getRoleCode(), RoleCodeEnum.FORUM_ADMIN.name()))) {
            // 原本有帖子权限
            if (!Objects.equals(param.getForumManageFlag(), Boolean.TRUE)) {
                // 移除权限
                userAuthCodeIntegrationService.removeRole(build(param.getUserId(), RoleCodeEnum.FORUM_ADMIN.name()));
            }
        } else {
            // 原本没有
            if (Objects.equals(param.getForumManageFlag(), Boolean.TRUE)) {
                // 添加权限
                userAuthCodeIntegrationService.addRole(build(param.getUserId(), RoleCodeEnum.FORUM_ADMIN.name()));
            }
        }
        if (userRoles.stream().anyMatch(p -> Objects.equals(p.getRoleCode(), RoleCodeEnum.VIRTUAL_ADMIN.name()))) {
            // 原本有帖子权限
            if (!Objects.equals(param.getVirtualManageFlag(), Boolean.TRUE)) {
                // 移除权限
                userAuthCodeIntegrationService.removeRole(build(param.getUserId(), RoleCodeEnum.VIRTUAL_ADMIN.name()));
            }
        } else {
            // 原本没有
            if (Objects.equals(param.getVirtualManageFlag(), Boolean.TRUE)) {
                // 添加权限
                userAuthCodeIntegrationService.addRole(build(param.getUserId(), RoleCodeEnum.VIRTUAL_ADMIN.name()));
            }
        }

        return null;
    }

    private UserRoleParam build(Long userId, String roleCode) {
        UserRoleParam param = new UserRoleParam();
        param.setUserId(userId);
        param.setRoleCode(roleCode);

        return param;
    }

}
