package com.bxm.localnews.admin.timer;

import com.bxm.localnews.admin.service.base.AdvertisementService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 广告位过期自动下线定时任务
 * @author wzy
 * @version 1.0
 * @date 2020/9/29 4:46 下午
 */
@Component
@Slf4j
public class AdvertOfflineTimer  extends AbstractCronTask<String> {

    private final AdvertisementService advertisementService;

    public AdvertOfflineTimer(AdvertisementService advertisementService) {
        this.advertisementService = advertisementService;
    }

    @Override
    protected ReturnT<String> service(String s) {
        log.info("==================下线过期广告位定时任务开启===================");
        advertisementService.offlineAdvertPosition();
        log.info("==================下线过期广告位定时任务结束===================");
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "每分钟扫描过期广告位，对过期广告位进行下架";
    }

    @Override
    public String cron() {
        return "0 */1 * * * ?";
    }
}