package com.bxm.localnews.admin.timer;

import com.bxm.localnews.admin.service.security.VipCardService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author gonzo
 * @date 2020-07-24 15:32
 **/
@Slf4j
@Component
public class BatchPhoneActiveTimer extends AbstractCronTask<String> {

    @Autowired
    private VipCardService vipCardService;

    @Override
    protected ReturnT<String> service(String param) {
        try {
            log.info("开始处理: {}", taskName());
            vipCardService.batchPhoneActive();
        } catch(Exception e) {
            log.error("处理: {} 失败", taskName(), e);
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "定时激活上报过手机号的vip";
    }

    @Override
    public String cron() {
        // 2分钟执行一次
        return "0 0/2 * * * ? ";
    }
}
