/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.impl;

import com.bxm.localnews.admin.common.HelpInfoProperties;
import com.bxm.localnews.admin.domain.HelpInfoMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.param.HelpInfoQueryParam;
import com.bxm.localnews.admin.service.activity.HelpInfoService;
import com.bxm.localnews.admin.vo.HelpInfo;
import com.bxm.localnews.admin.vo.User;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class HelpInfoServiceImpl
implements HelpInfoService {
    @Resource
    private HelpInfoMapper helpInfoMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private HelpInfoProperties helpInfoProperties;

    @Override
    public PageWarper<HelpInfo> getList(HelpInfoQueryParam param) {
        PageWarper result = new PageWarper(this.helpInfoMapper.getList(param));
        if (CollectionUtils.isNotEmpty((Collection)result.getList())) {
            for (HelpInfo helpInfo : result.getList()) {
                this.completeInfo(helpInfo);
            }
        }
        return result;
    }

    @Override
    public HelpInfo getDetailById(Long id) {
        HelpInfo helpInfo = this.helpInfoMapper.selectByPrimaryKey(id);
        this.completeInfo(helpInfo);
        return helpInfo;
    }

    @Override
    public Message saveOrUpdate(HelpInfo helpInfo) {
        int update;
        if (null == helpInfo.getType() || 1 != helpInfo.getType() && 2 != helpInfo.getType()) {
            return Message.build((boolean)false).setMessage("\u53c2\u6570\u6709\u8bef");
        }
        if (2 == helpInfo.getType() && (null == helpInfo.getHelperName() || null == helpInfo.getCreator())) {
            return Message.build((boolean)false).setMessage("\u53c2\u6570\u6709\u8bef");
        }
        Long id = helpInfo.getId();
        if (null == id) {
            if (1 == helpInfo.getType()) {
                if (this.helpInfoMapper.countUserHelpInfo(helpInfo.getHelperId()) > 0) {
                    return Message.build((boolean)false).setMessage("\u8be5\u7528\u6237\u5df2\u7ecf\u52a9\u529b\u8fc7\u6d3b\u52a8");
                }
                User user = this.userMapper.selectByUserId(helpInfo.getHelperId().longValue());
                if (null == user) {
                    return Message.build((boolean)false).setMessage("\u67e5\u4e0d\u5230\u5bf9\u5e94\u7528\u6237");
                }
                helpInfo.setHelperName(user.getNickname());
                helpInfo.setHelperImg(user.getHeadImg());
            } else if (2 == helpInfo.getType()) {
                if (this.helpInfoMapper.countUserHelpInfo(helpInfo.getCreator()) > 0) {
                    return Message.build((boolean)false).setMessage("\u8be5\u7528\u6237\u5df2\u7ecf\u52a9\u529b\u8fc7\u6d3b\u52a8");
                }
                if (this.helpInfoMapper.countHelpTeamByName(helpInfo.getHelperName()) > 0) {
                    return Message.build((boolean)false).setMessage("\u5df2\u5b58\u5728\u8be5\u56e2\u961f\u540d");
                }
                User creator = this.userMapper.selectByUserId(helpInfo.getCreator().longValue());
                if (null == creator) {
                    return Message.build((boolean)false).setMessage("\u67e5\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d77\u4eba");
                }
                helpInfo.setCreatorName(creator.getNickname());
                helpInfo.setCreatorImg(creator.getHeadImg());
                helpInfo.setHelperId(this.sequenceCreater.nextLongId());
                if (StringUtils.isBlank((String)helpInfo.getHelperImg())) {
                    helpInfo.setHelperImg(this.helpInfoProperties.getDefaultTeamImg());
                }
                this.helpInfoMapper.insertTeamInfo(helpInfo);
                this.helpInfoMapper.insertTeamUserRelation(helpInfo.getHelperId(), helpInfo.getCreator());
            }
            helpInfo.setId(this.sequenceCreater.nextLongId());
            update = this.helpInfoMapper.insertSelective(helpInfo);
        } else {
            update = this.helpInfoMapper.updateByPrimaryKeySelective(helpInfo);
            if (2 == helpInfo.getType()) {
                this.helpInfoMapper.updateTeamInfo(helpInfo);
            }
        }
        if (update > 0) {
            return Message.build((boolean)true);
        }
        return Message.build((boolean)false).setMessage("\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
    }

    private void completeInfo(HelpInfo helpInfo) {
        if (null == helpInfo) {
            return;
        }
        if (2 == helpInfo.getType()) {
            HelpInfo teamInfo = this.helpInfoMapper.selectTeamInfoById(helpInfo.getHelperId());
            helpInfo.setCreator(teamInfo.getCreator());
            helpInfo.setCreatorName(teamInfo.getCreatorName());
            helpInfo.setCreatorImg(teamInfo.getCreatorImg());
        }
    }
}

