/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.activity.impl;

import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.admin.common.BizConfigProperties;
import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.domain.PrivilegeAreaMapper;
import com.bxm.localnews.admin.domain.PrivilegeMapper;
import com.bxm.localnews.admin.enums.PrivilegeStatusEnum;
import com.bxm.localnews.admin.param.PrivilegeParam;
import com.bxm.localnews.admin.param.PrivilegeQueryParam;
import com.bxm.localnews.admin.service.activity.CommodityService;
import com.bxm.localnews.admin.service.activity.PrivilegeService;
import com.bxm.localnews.admin.service.base.ShortLinkService;
import com.bxm.localnews.admin.vo.CommodityBean;
import com.bxm.localnews.admin.vo.PrivilegeAreaBean;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrivilegeServiceImpl
extends BaseService
implements PrivilegeService {
    private PrivilegeMapper privilegeMapper;
    private AliyunOSSService aliyunOSSService;
    private CommodityService commodityService;
    private HttpClientService httpClientService;
    private PrivilegeAreaMapper privilegeAreaMapper;
    private ShortLinkService shortLinkService;
    private BizConfigProperties bizConfigProperties;
    private RedisStringAdapter redisStringAdapter;
    private SqlSessionTemplate primarySessionTemplate;

    @Autowired
    public PrivilegeServiceImpl(PrivilegeMapper privilegeMapper, PrivilegeAreaMapper privilegeAreaMapper, AliyunOSSService aliyunOSSService, CommodityService commodityService, HttpClientService httpClientService, ShortLinkService shortLinkService, BizConfigProperties bizConfigProperties, RedisStringAdapter redisStringAdapter, SqlSessionTemplate primarySessionTemplate) {
        this.privilegeMapper = privilegeMapper;
        this.aliyunOSSService = aliyunOSSService;
        this.commodityService = commodityService;
        this.httpClientService = httpClientService;
        this.privilegeAreaMapper = privilegeAreaMapper;
        this.shortLinkService = shortLinkService;
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.primarySessionTemplate = primarySessionTemplate;
    }

    @Override
    public Message save(PrivilegeParam param) {
        PrivilegeBean entity = this.convert(param);
        entity.setShareBgUrl(param.getThumbnailUrl());
        entity.setDeleteFlag(0);
        entity.setAddTime(new Date());
        entity.setStatus(PrivilegeStatusEnum.BEGIN.getCode());
        this.saveAreaRelation(param, entity.getId());
        this.privilegeMapper.insert(entity);
        this.updateRedisByPrivilegeArea(param.getAreaCodes());
        return Message.build((int)1);
    }

    private KeyGenerator getPriviligeListKey(String areaCode) {
        return RedisConfig.PRIVILEGE_lIST.copy().appendKey((Object)areaCode);
    }

    private void saveAreaRelation(PrivilegeParam param, long id) {
        this.privilegeAreaMapper.deleteByPrivilegeId(Long.valueOf(id));
        if (param.getGlobalFlag() == 1) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)param.getAreaCodes())) {
            Object[] relationCodeArray = StringUtils.split((String)param.getAreaCodes(), (String)",");
            MybatisBatchBuilder.create(PrivilegeAreaMapper.class, (Object[])relationCodeArray).sessionTemplate(this.primarySessionTemplate).run((mapper, element) -> {
                PrivilegeAreaBean privilegeAreaBean = new PrivilegeAreaBean();
                privilegeAreaBean.setId(Long.valueOf(this.nextId()));
                privilegeAreaBean.setAreaCode(element);
                privilegeAreaBean.setPrivilegeId(Long.valueOf(id));
                return mapper.insert(privilegeAreaBean);
            });
        }
    }

    @Override
    public Message modify(PrivilegeParam param) {
        Message message = Message.build((int)1);
        PrivilegeBean entity = this.convert(param);
        this.saveAreaRelation(param, entity.getId());
        this.privilegeMapper.updateByPrimaryKey(entity);
        this.updateRedisByPrivilegeArea(param.getAreaCodes());
        return message;
    }

    private PrivilegeBean convert(PrivilegeParam param) {
        PrivilegeBean entity = new PrivilegeBean();
        BeanUtils.copyProperties((Object)param, (Object)entity);
        if (param.getId() <= 0L) {
            entity.setId(this.nextId());
        }
        if (param.getCommodityId() > 0L) {
            CommodityBean commodityDetail = this.commodityService.get(param.getCommodityId());
            if (null != commodityDetail) {
                entity.setMerchantId(commodityDetail.getMechantId());
            } else {
                this.logger.error("\u5546\u54c1[{}]\u5df2\u88ab\u5220\u9664\uff0c\u5173\u8054\u6d3b\u52a8\u7684\u5546\u54c1\u4e0d\u5141\u8bb8\u5220\u9664", (Object)param.getCommodityId());
            }
        }
        return entity;
    }

    @Override
    public PageWarper<PrivilegeBean> queryByPage(PrivilegeQueryParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        PageWarper pageWarper = new PageWarper(this.privilegeMapper.queryByPageSize(param));
        pageWarper.getList().forEach(privilegeBean -> privilegeBean.setPrivilegeAreas(this.privilegeAreaMapper.getPrivilegeAreas(Long.valueOf(privilegeBean.getId()))));
        pageWarper.getList().forEach(privilegeBean -> privilegeBean.setShortUrl4QRCode(this.shortLinkService.getPrivilegeShareShortLink("id=" + privilegeBean.getId() + "&posterFlag=chook")));
        pageWarper.getList().forEach(privilegeBean -> privilegeBean.setShortUrl4Poster(this.shortLinkService.getPrivilegeShareShortLink("id=" + privilegeBean.getId())));
        return pageWarper;
    }

    @Override
    public PrivilegeBean get(long id) {
        PrivilegeBean entity = this.privilegeMapper.selectByPrimaryKey(Long.valueOf(id));
        entity.setPrivilegeAreas(this.privilegeAreaMapper.getPrivilegeAreas(Long.valueOf(entity.getId())));
        return entity;
    }

    @Override
    public Message remove(long id) {
        PrivilegeBean entity = this.get(id);
        if (entity == null) {
            return Message.build((boolean)false).setMessage("\u6d3b\u52a8ID\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        Message message = Message.build((int)this.privilegeMapper.deleteByPrimaryKey(Long.valueOf(id)));
        this.updateRedisByPrivilegeId(id);
        return message;
    }

    @Override
    public Message changeEnable(long id, int status) {
        this.privilegeMapper.changeEnable(id, status);
        if (status == 1) {
            PrivilegeBean privilegeBean = this.get(id);
        }
        this.updateRedisByPrivilegeId(id);
        return Message.build((boolean)true);
    }

    @Override
    public Message changeOrder(long id, int order) {
        this.privilegeMapper.changeOrder(id, order);
        this.updateRedisByPrivilegeId(id);
        return Message.build((boolean)true);
    }

    private void updateRedisByPrivilegeId(long id) {
        List privilegeAreaBeanList = this.privilegeAreaMapper.getPrivilegeAreas(Long.valueOf(id));
        for (PrivilegeAreaBean privilegeAreaBean : privilegeAreaBeanList) {
            List privilegeListDTOList = this.privilegeMapper.listAllPrivilege(privilegeAreaBean.getAreaCode());
            this.redisStringAdapter.set(this.getPriviligeListKey(privilegeAreaBean.getAreaCode()), (Object)privilegeListDTOList);
        }
    }

    private void updateRedisByPrivilegeArea(String codes) {
        String[] relationCodeArray;
        if (StringUtils.isEmpty((CharSequence)codes)) {
            return;
        }
        for (String code : relationCodeArray = StringUtils.split((String)codes, (String)",")) {
            List privilegeListDTOList = this.privilegeMapper.listAllPrivilege(code);
            this.redisStringAdapter.set(this.getPriviligeListKey(code), (Object)privilegeListDTOList);
        }
    }
}

