/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.service.base.ShortLinkService;
import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.base.model.dto.AvailableDomainInfo;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.ShortUrlGenerator;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class ShortLinkServiceImpl
implements ShortLinkService {
    private RedisStringAdapter redisStringAdapter;
    private DomainIntegrationService domainIntegrationService;

    @Override
    public String getShortUrl(String url, boolean expired) {
        StringBuilder sortUrl = new StringBuilder();
        Optional baseUrlInfoByScene = this.domainIntegrationService.getBaseUrlInfoByScene(DomainScene.SHORT, null, null);
        sortUrl.append(baseUrlInfoByScene.isPresent() ? ((AvailableDomainInfo)baseUrlInfoByScene.get()).getBaseUrl() : "").append("t").append("/");
        String key = ShortUrlGenerator.getShortUrl((String)url)[0];
        sortUrl.append(key);
        if (expired) {
            this.redisStringAdapter.set(RedisConfig.SHORT_URL.copy().appendKey((Object)key), (Object)url, 7776000L);
        } else {
            this.redisStringAdapter.set(RedisConfig.SHORT_URL.copy().appendKey((Object)key), (Object)url);
        }
        return sortUrl.toString();
    }

    @Override
    public String getPrivilegeShareShortLink(String param) {
        String url = null;
        url = "?" + param;
        return this.getShortUrl(url, true);
    }

    public ShortLinkServiceImpl(RedisStringAdapter redisStringAdapter, DomainIntegrationService domainIntegrationService) {
        this.redisStringAdapter = redisStringAdapter;
        this.domainIntegrationService = domainIntegrationService;
    }
}

