/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.market.impl;

import com.bxm.localnews.admin.domain.MarketCommodityMapper;
import com.bxm.localnews.admin.param.MarketCommodityQueryParam;
import com.bxm.localnews.admin.service.market.MarketCommodityService;
import com.bxm.localnews.admin.vo.MarketCommodity;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MarketCommodityServiceImpl
implements MarketCommodityService {
    @Resource
    private MarketCommodityMapper marketCommodityMapper;
    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public PageWarper<MarketCommodity> getList(MarketCommodityQueryParam param) {
        return new PageWarper(this.marketCommodityMapper.getList(param));
    }

    @Override
    public MarketCommodity selectByPrimaryKey(Long id) {
        return this.marketCommodityMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateStatus(Long id, Byte status) {
        MarketCommodity marketCommodity = this.marketCommodityMapper.selectByPrimaryKey(id);
        if (null == marketCommodity) {
            return 0;
        }
        marketCommodity.setStatus(status);
        return this.marketCommodityMapper.updateByPrimaryKeySelective(marketCommodity);
    }

    @Override
    public int saveOrUpdate(MarketCommodity marketCommodity) {
        int update;
        Long id = marketCommodity.getId();
        if (null == id) {
            id = this.sequenceCreater.nextLongId();
            marketCommodity.setId(id);
            marketCommodity.setCreateTime(new Date());
            update = this.marketCommodityMapper.insert(marketCommodity);
        } else {
            update = this.marketCommodityMapper.updateByPrimaryKeySelective(marketCommodity);
        }
        return update;
    }

    @Override
    public int updateOrder(Long id, Integer order) {
        MarketCommodity marketCommodity = this.marketCommodityMapper.selectByPrimaryKey(id);
        if (null == marketCommodity) {
            return 0;
        }
        marketCommodity.setOrder(order);
        return this.marketCommodityMapper.updateByPrimaryKeySelective(marketCommodity);
    }

    @Override
    public int deleteById(Long id, Long deletor) {
        MarketCommodity marketCommodity = this.marketCommodityMapper.selectByPrimaryKey(id);
        if (null == marketCommodity) {
            return 0;
        }
        marketCommodity.setDeleteFlag(Byte.valueOf((byte)1));
        marketCommodity.setDeletor(deletor);
        marketCommodity.setDeleteTime(new Date());
        return this.marketCommodityMapper.updateByPrimaryKeySelective(marketCommodity);
    }
}

