/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.service.security;

import com.bxm.localnews.admin.constant.VipCardRedisKey;
import com.bxm.localnews.admin.dto.BatchActiveDTO;
import com.bxm.localnews.admin.dto.ImportResultDTO;
import com.bxm.localnews.admin.dto.security.UserInfoDTO;
import com.bxm.localnews.admin.integration.UserVipIntegrationService;
import com.bxm.localnews.admin.param.AddTimesParam;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.service.security.AdminUserBaseInfoService;
import com.bxm.localnews.admin.service.security.VipCardService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class VipCardServiceImpl
implements VipCardService {
    private static final Logger log = LoggerFactory.getLogger(VipCardServiceImpl.class);
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private UserVipIntegrationService userVipIntegrationService;
    @Autowired
    private AdminUserBaseInfoService adminUserBaseInfoService;

    @Override
    public List<ImportResultDTO> batchSavePhoneActive(String phones) {
        if (StringUtils.isBlank((CharSequence)phones)) {
            return Collections.emptyList();
        }
        Arrays.stream(phones.split("\n")).forEach(p -> {
            BatchActiveDTO activeDTO = new BatchActiveDTO();
            activeDTO.setPhone(p);
            activeDTO.setHasActived(Integer.valueOf(0));
            activeDTO.setActiveTime(null);
            this.redisHashMapAdapter.put(VipCardRedisKey.BATCH_ACTIVE_PHONE, p, (Object)activeDTO);
        });
        this.batchPhoneActive();
        return Collections.emptyList();
    }

    @Override
    public List<BatchActiveDTO> listAllPhones() {
        return this.redisHashMapAdapter.values(VipCardRedisKey.BATCH_ACTIVE_PHONE, BatchActiveDTO.class);
    }

    @Override
    public void batchPhoneActive() {
        List batchActiveDTOS = this.redisHashMapAdapter.values(VipCardRedisKey.BATCH_ACTIVE_PHONE, BatchActiveDTO.class);
        batchActiveDTOS.forEach(p -> {
            if (Objects.equals(p.getHasActived(), 1)) {
                return;
            }
            UserInfoParam param = new UserInfoParam();
            param.setPhone(p.getPhone());
            PageWarper<UserInfoDTO> userInfoDTOS = this.adminUserBaseInfoService.queryUserInfoDTO(param);
            if (CollectionUtils.isEmpty((Collection)userInfoDTOS.getList())) {
                log.info("\u624b\u673a\u53f7: {} \u4e0d\u5b58\u5728\u7528\u6237 \u8df3\u8fc7", (Object)p.getPhone());
                return;
            }
            UserInfoDTO userInfoDTO = (UserInfoDTO)userInfoDTOS.getList().get(0);
            if (StringUtils.isBlank((CharSequence)userInfoDTO.getUserId())) {
                return;
            }
            if (Objects.nonNull(userInfoDTO.getTotalOpenNum())) {
                log.info("\u624b\u673a\u53f7: {} \u7528\u6237: {} \u5df2\u6fc0\u6d3b \u6fc0\u6d3b\u7801\u683c\u5f0f: {} ", new Object[]{p.getPhone(), userInfoDTO.getUserId(), userInfoDTO.getTotalOpenNum()});
                if (userInfoDTO.getTotalOpenNum() < 500) {
                    log.info("\u624b\u673a\u53f7: {} \u7528\u6237: {} \u589e\u52a0500\u4e2a\u6fc0\u6d3b\u7801", (Object)p.getPhone(), (Object)userInfoDTO.getUserId());
                    AddTimesParam addTimesParam = new AddTimesParam();
                    addTimesParam.setUserId(Long.valueOf(Long.parseLong(userInfoDTO.getUserId())));
                    addTimesParam.setTimes(Integer.valueOf(500));
                    this.userVipIntegrationService.addNum(addTimesParam);
                }
            } else {
                log.info("\u624b\u673a\u53f7: {} \u7528\u6237: {} \u589e\u52a0\u6fc0\u6d3bvip\u4fe1\u606f", (Object)p.getPhone(), (Object)userInfoDTO.getUserId());
                ImportResultDTO resultDTO = this.userVipIntegrationService.manualActiveVip(p.getPhone());
                if (!Objects.equals(resultDTO.getSuccess(), Boolean.TRUE)) {
                    return;
                }
            }
            BatchActiveDTO activeDTO = new BatchActiveDTO();
            activeDTO.setPhone(p.getPhone());
            activeDTO.setHasActived(Integer.valueOf(1));
            activeDTO.setActiveTime(new Date());
            this.redisHashMapAdapter.put(VipCardRedisKey.BATCH_ACTIVE_PHONE, p.getPhone(), (Object)activeDTO);
        });
    }
}

