package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.DictService;
import com.bxm.localnews.common.dto.DictDto;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "1-07 数据字典相关接口")
@RestController
@RequestMapping("{version}/base/dict")
public class DictController {

    private DictService dictService;

    public DictController(DictService dictService) {
        this.dictService = dictService;
    }

    @ApiOperation("1-07-1 [v1]加载数据字典")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "group", value = "字典分组，取值详见CF文档", required = true),
            @ApiImplicitParam(name = "deep", value = "获取深度,不传或传0将返回完整的字段，1表示仅获取第一层")
    })
    @GetMapping("load")
    @ApiVersion(1)
    public Json<List<DictDto>> load(@RequestParam(value = "group") String group, @RequestParam(value = "deep", required = false) Integer deep) {
        return Json.ok(dictService.load(group, deep));
    }

    @ApiOperation("1-07-2 [v1]根据上级字典编码获取下一层级字典列表，用于延迟加载的情况")
    @ApiImplicitParam(name = "parentCode", value = "上级字典编码，取值来自1-07-1", required = true)
    @GetMapping("children")
    @ApiVersion(1)
    public Json<List<DictDto>> getChildren(@RequestParam String parentCode) {
        return Json.ok(dictService.children(parentCode));
    }
}
