package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.EquipmentService;
import com.bxm.localnews.common.param.EquipmentParam;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "1-06 设备信息上报")
@RequestMapping("/api/device")
@RestController
public class EquipmentController {

    @Autowired
    private EquipmentService equipmentService;

    @ApiOperation(value = "1-06-01 上报设备信息", notes = "将用户的设备信息上传至服务器做数据留存," +
            "返回一个唯一标识，在每次大启动的时候调用此接口(以后可能会要求上报更多的参数)")
    @PostMapping(value = "/report")
    public Json<String> createTempUser(EquipmentParam equipmentParam) {
        return ResultUtil.genSuccessResult(equipmentService.save(equipmentParam));
    }
}
