package com.bxm.localnews.base.facade.controller;

import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.param.PointReportParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;

/**
 * @author zhaoyadong 2019/3/6 21:51
 * @desc
 */
@Api(tags = "1-100 [内部接口]日志记录")
@RestController
@RequestMapping("facade/biz/log")
public class BizLogFacadeController {

    private final BizLogService bizLogService;

    @Autowired
    public BizLogFacadeController(BizLogService bizLogService) {
        this.bizLogService = bizLogService;
    }

    @ApiOperation(value = "1-100-1 [已废弃]用户创建增加日志", notes = "修改为调用1-100-11")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "channel", value = "渠道信息", required = true),
            @ApiImplicitParam(name = "token", value = "token")
    })
    @PostMapping("/register")
    @Deprecated
    public void newUser(@RequestParam("userId") Long userId, @RequestParam("channel") String channel,
                        @RequestParam("token") String token, @RequestParam("amount") BigDecimal amount,
                        @RequestParam("registerChannel") String registerChannel,
                        @RequestParam(value = "rid", required = false) String rid, @RequestParam(value = "platform", required = false) Integer platform) {
        bizLogService.newUser(userId, channel, token, amount, registerChannel, rid, platform);
    }

    @ApiOperation(value = "1-100-2 [已废弃]用户登陆增加日志", notes = "修改为调用1-100-11")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @PostMapping("/login")
    @Deprecated
    public void login(@RequestParam("userId") Long userId, @RequestParam(value = "platform", required = false) Integer platform) {
        bizLogService.login(userId, platform);
    }

    @ApiOperation(value = "1-100-3 [已废弃]用户修改性别增加日志", notes = "修改为调用1-100-11")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "sex", value = "性别", required = true)
    })
    @PostMapping("/changeGender")
    @Deprecated
    public void changeGender(@RequestParam("userId") Long userId, @RequestParam("sex") int sex,
                             @RequestParam(value = "platform", required = false) Integer platform) {
        bizLogService.changeGender(userId, sex, platform);
    }

    @ApiOperation(value = "1-100-4 [已废弃]用户修改定位信息增加日志", notes = "修改为调用1-100-11")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true)
    })
    @PostMapping("/changeArea")
    @Deprecated
    public void changeArea(@RequestParam("userId") Long userId, @RequestParam("areaCode") String areaCode,
                           @RequestParam(value = "platform", required = false) Integer platform) {
        bizLogService.changeArea(userId, areaCode, platform);
    }

    @ApiOperation(value = "1-100-5 [已废弃]用户邀请关系建立增加日志", notes = "修改为调用1-100-11")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "invitedUserId", value = "受邀人用户id", required = true),
    })
    @PostMapping("/inviteSuccessed")
    @Deprecated
    public void inviteSuccessed(@RequestParam("userId") Long userId, @RequestParam("invitedUserId") Long invitedUserId,
                                @RequestParam(value = "platform", required = false) Integer platform) {
        bizLogService.inviteSuccessed(userId, invitedUserId, platform);
    }

    @ApiOperation(value = "1-100-6 [已废弃]用户发帖成功", notes = "修改为调用1-100-11")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true)
    })
    @PostMapping("/forumSuccessed")
    @Deprecated
    public void forumSuccessed(@RequestParam("userId") Long userId,
                               @RequestParam(value = "areaCode", required = false) String areaCode,
                               @RequestParam(value = "platform", required = false) Integer platform) {
        bizLogService.forumSucceed(userId, areaCode, platform);
    }

    @ApiOperation(value = "1-100-7 [已废弃]用户评论成功", notes = "修改为调用1-100-11")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "id", value = "帖子或者新闻、小视频id", required = true),
            @ApiImplicitParam(name = "type", value = "内容类型", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true)
    })
    @PostMapping("/replySuccessed")
    @Deprecated
    public void replySuccessed(@RequestParam("userId") Long userId, @RequestParam("id") Long id,
                               @RequestParam("type") Integer type, @RequestParam(value = "areaCode", required = false) String areaCode,
                               @RequestParam(value = "platform", required = false) Integer platform) {
        bizLogService.replySucceed(userId, id, type, areaCode, platform);
    }

    @ApiOperation(value = "1-100-8 [已废弃]分享帖子成功", notes = "修改为调用1-100-11")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true)
    })
    @PostMapping("/shareForumSuccessed")
    @Deprecated
    public void shareForumSuccessed(@RequestParam("userId") Long userId, @RequestParam("id") Long id,
                                    @RequestParam(value = "areaCode", required = false) String areaCode,
                                    @RequestParam(value = "platform", required = false) Integer platform) {
        bizLogService.shareForumSucceed(userId, id, areaCode, platform);
    }

    @ApiOperation(value = "1-100-9 [已废弃]帖子点赞成功", notes = "修改为调用1-100-11")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true)
    })
    @PostMapping("/forumLikeSuccessed")
    @Deprecated
    public void forumLikeSuccessed(@RequestParam("userId") Long userId, @RequestParam("id") Long id,
                                   @RequestParam(value = "areaCode", required = false) String areaCode,
                                   @RequestParam(value = "platform", required = false) Integer platform) {
        bizLogService.forumLikeSucceed(userId, id, areaCode, platform);
    }

    @ApiOperation(value = "1-100-10 [已废弃]帖子收藏成功", notes = "修改为调用1-100-11")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true)
    })
    @PostMapping("/forumCollectSuccessed")
    @Deprecated
    public void forumCollectSuccessed(@RequestParam("userId") Long userId, @RequestParam("id") Long id,
                                      @RequestParam("type") Integer type,
                                      @RequestParam(value = "areaCode", required = false) String areaCode,
                                      @RequestParam(value = "platform", required = false) Integer platform) {
        bizLogService.forumCollectSucceed(userId, id, areaCode, type, platform);
    }

    @ApiOperation(value = "1-100-11 通用日志埋点", notes = "参数为对应埋点需要的参数，" +
            "包括事件值等.后续再有埋点需求，使用通用埋点， " +
            "不进行单独定义。埋点具体需要的参数，由调用服务的Integration进行封装")
    @PostMapping("/point")
    public void point(@RequestBody PointReportParam param) {
        bizLogService.report(param);
    }
}
