/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.ClientConfigService;
import com.bxm.localnews.common.dto.MerchantCategoryDTO;
import com.bxm.localnews.common.param.DomainInfoParam;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-02 \u5ba2\u6237\u7aef\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f"}, description="\u7528\u4e8e\u5ba2\u6237\u7aef\u83b7\u53d6\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f")
@RequestMapping(value={"/api/client/config"})
@RestController
public class ClientConfigController {
    private final ClientConfigService clientConfigService;

    @ApiOperation(value="1-02-1 \u83b7\u53d6\u8df3\u8f6c\u9875\u9762\u7684\u8df3\u8f6c\u7c7b\u578b", notes="0\uff1a\u5173\u95ed 1:\u5f00\u542f")
    @GetMapping(value={"/jump/type"})
    public Json<Integer> getByMobileType() {
        return ResultUtil.genSuccessResult((Object)this.clientConfigService.getJumpUrlType());
    }

    @ApiOperation(value="1-02-2 \u6839\u636ekey\u83b7\u53d6\u5bf9\u5e94\u7684value", notes="")
    @GetMapping(value={"/key"})
    public Json<String> getValueByKey(String key) {
        return ResultUtil.genSuccessResult((Object)this.clientConfigService.getValueByKey(key));
    }

    @ApiOperation(value="1-02-3 \u83b7\u53d6\u5546\u5bb6\u5165\u9a7b\u7c7b\u522b", notes="\u83b7\u53d6\u5546\u5bb6\u5165\u9a7b\u7c7b\u522b:\u9910\u996e\u3001\u7535\u5f71\u3001KTV\u7b49")
    @GetMapping(value={"/merchant/category/list"})
    public Json<List<MerchantCategoryDTO>> listLabel() {
        return ResultUtil.genSuccessResult(this.clientConfigService.listMerchantCategory().stream().map(x -> new MerchantCategoryDTO(x, x)).collect(Collectors.toList()));
    }

    @ApiOperation(value="1-02-4 \u83b7\u53d6\u5ba2\u6237\u7aef\u6240\u6709\u914d\u7f6e\u4fe1\u606f key-value\u5f62\u5f0f", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="platform", value="\u5e73\u53f0\u7c7b\u578b", required=false)})
    @GetMapping(value={"all"})
    public Json<Map<String, String>> getAllConfig(@RequestParam(value="platform", required=false) Integer platform) {
        return ResultUtil.genSuccessResult((Object)this.clientConfigService.getAllConfig(platform));
    }

    @Deprecated
    @ApiOperation(value="1-02-5 \u3010\u5df2\u5f03\u7528\u3011\u83b7\u53d6\u7ad9\u5916\u5206\u4eab\u94fe\u63a5\u7684base url", notes="\u8fd4\u56de\u7684url\u7c7b\u578b\u4e3a https://domain/baseUrl/ \u7136\u540e\u4e0e\u8981\u5206\u4eab\u7684url\u62fc\u63a5\u5373\u53ef")
    @GetMapping(value={"getBaseH5UrlByScene"})
    public ResponseJson<String> getBaseH5UrlByScene(@RequestParam(value="scene") String scene) {
        DomainInfoParam param = new DomainInfoParam();
        param.setScene(scene);
        return ResponseJson.ok((Object)this.clientConfigService.getBaseH5UrlByScene(param));
    }

    @ApiOperation(value="1-02-6 \u6839\u636e\u573a\u666f\u83b7\u53d6base url \u662f1-02-5\u63a5\u53e3\u7684\u65b0\u7248\u672c", notes="\u8fd4\u56de\u7684url\u7c7b\u578b\u4e3a https://domain/baseUrl/ \u7136\u540e\u4e0e\u8981\u5206\u4eab\u7684url\u62fc\u63a5\u5373\u53ef")
    @GetMapping(value={"getBaseH5UrlBySceneNew"})
    public ResponseJson<String> getBaseH5UrlBySceneNew(DomainInfoParam param) {
        return ResponseJson.ok((Object)this.clientConfigService.getBaseH5UrlByScene(param));
    }

    public ClientConfigController(ClientConfigService clientConfigService) {
        this.clientConfigService = clientConfigService;
    }
}

