package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.AreaInfoService;
import com.bxm.localnews.common.dto.LocationSwitchDTO;
import com.bxm.localnews.common.param.GetAreaInfoParam;
import com.bxm.localnews.common.param.LocationSwitchParam;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.AreaInfo;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Api(tags = "1-08 新版本地址基础服务接口", description = "地址基础服务接口")
@RequestMapping("{version}/api/area")
@RestController
@AllArgsConstructor
public class LocationNewController {

    private final AreaInfoService areaInfoService;

    private static final String UNDEFINED = "undefined";

    @GetMapping(value = "/info/{code}")
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "path", name = "code", value = "区域编号 一般为12位", required = true),
    })
    @ApiOperation(value = "1-08-1 [v1]根据code获取区域信息 查询不到则返回空对象", notes = "")
    @ApiVersion(1)
    public Json<AreaInfo> getAreaInfo(@PathVariable String code, GetAreaInfoParam param) {
        // 这里的带v的接口会出现新增的接口不被正确转发的情况 因为网关在去除v1之后，是能根据路径全匹配到一个地址的（老版本的接口就是不带v的）所以能正常转发
        // 但是如果再添加一个接口，就无法正常转发了，因为去掉v之后，老版本并不一定有对应的接口

        if (UNDEFINED.equals(code)) {
            return ResultUtil.genFailedResult("code非法，无法定位:"+code);
        }

        param.setCode(code);
        // 根据code查询信息，查不到不给默认值 且code需要当做最新编码查询
        return ResultUtil.genSuccessResult(areaInfoService.getAreaInfo(param, true, true));
    }


    @GetMapping(value = "location/switch")
    @ApiOperation(value = "1-08-2 [v1] 根据客户端本地存储code和第三方sdk获取的code获取需要切换的城市信息", notes = "")
    @ApiVersion(1)
    public Json<LocationSwitchDTO> locationSwitch(LocationSwitchParam param) {
        return ResultUtil.genSuccessResult(areaInfoService.locationSwitch(param));
    }


}
