package com.bxm.localnews.base.controller;

import com.bxm.component.poster.context.PosterContext;
import com.bxm.component.poster.engine.PosterEngine;
import com.bxm.component.poster.output.impl.AliyunOssOutput;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author liujia
 * @date 12/18/20 6:41 PM
 **/
@Api(tags = "1-10 海报生成服务", description = "生成指定的海报信息")
@RequestMapping("{version}/base/public/poster")
@RestController
public class PosterController {

    private final PosterEngine posterEngine;

    private final AliyunOssOutput aliyunOssOutput;

    @Autowired
    public PosterController(PosterEngine posterEngine, AliyunOssOutput aliyunOssOutput) {
        this.posterEngine = posterEngine;
        this.aliyunOssOutput = aliyunOssOutput;
    }

    @ApiOperation(value = "1-10-01 根据指定参数，生成海报", notes = "具体生成配置详见：http://wiki.bianxianmao.cn/pages/viewpage.action?pageId=25991391")
    @PostMapping("gen")
    public ResponseJson<String> gen(@RequestBody PosterContext context) {
        context.setPosterOutput(aliyunOssOutput);
        return ResponseJson.ok(posterEngine.generate(context));
    }
}
