package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.PrivacyAgreementReportService;
import com.bxm.localnews.common.param.PrivacyAgreeReportParam;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author wzy
 * @date 2020/8/15 14:41
 **/
@Api(tags = "1-09 隐私协议弹窗上报接口", description = "上报用户信息")
@RequestMapping("{version}/base/privacy")
@RestController
public class PrivacyAgreementReportController {

    @Resource
    private PrivacyAgreementReportService privacyAgreementReportService;

    @ApiOperation(value = "1-09-1 上报隐私弹窗用户信息", notes = "需要传递用户id和设备id和协议内容")
    @PostMapping(value = "report")
    @ApiVersion(1)
    public Json privacyAgreementReport(@RequestBody PrivacyAgreeReportParam privacyAgreeReportParam) {
        privacyAgreementReportService.insertSelective(privacyAgreeReportParam);
        return ResultUtil.genSuccessResult();
    }
}
