package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.dto.ShortLinkMeta;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.ShortLinkReq;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

import static com.bxm.localnews.common.rediskey.ShortUrlRedisKey.SHORT_URL;

@Api(tags = "1-03 短链接接口", description = "短链接转换与跳转")
@RestController
@RequestMapping("t")
@AllArgsConstructor
public class ShortLinkController {

    private ShortLinkService shortLinkService;

    private RedisStringAdapter redisStringAdapter;

    private BaseUrlFacadeService baseUrlFacadeService;


    @ApiOperation(value = "1-03-1 获取短链接跳转地址并转发")
    @ApiImplicitParam(name = "key", value = "短链接", required = true)
    @RequestMapping(value = {"/{key}"}, method = {RequestMethod.GET, RequestMethod.POST})
    public void getUrl(@PathVariable String key, HttpServletResponse resp) throws IOException {
        String url = this.redisStringAdapter.get(SHORT_URL.copy().appendKey(key), String.class);
        if (StringUtils.isNotEmpty(url)) {
            resp.sendRedirect(url);
            return;
        }
        // key不存在，则默认注册页面
        resp.sendRedirect(baseUrlFacadeService.getShortLinkBaseUrl() + "/register.html");
    }

    @ApiOperation(value = "1-03-2 站内扫一扫，跳H5拜师")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "key", value = "短链接", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    })
    @RequestMapping(value = {"/{key}/{userId}"}, method = {RequestMethod.GET, RequestMethod.POST})
    public void getUrl(@PathVariable String key, @PathVariable String userId, HttpServletResponse resp) throws IOException {
        String url = this.redisStringAdapter.get(SHORT_URL.copy().appendKey(key), String.class);
        if (StringUtils.isNotEmpty(url) && StringUtils.isNotEmpty(userId)) {
            resp.sendRedirect(url + "&apprentice=" + userId);
        }
    }

    @ApiOperation(value = "1-03-3 获取对应类型的短链接")
    @RequestMapping(value = "/getShortUrl", method = {RequestMethod.GET, RequestMethod.POST})
    public Json<ShortLinkMeta> getRegisterShortURL(ShortLinkReq req) {
        ShortLinkMeta meta = new ShortLinkMeta();
        //实际地址地址
        if (null == req.getType()) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "缺少必要参数");
        }
        if (AppConst.SHORT_LINK_TYPE.REGISTER == req.getType()) {
            meta.setSortUrl(this.shortLinkService.getRegisterShortUrl(req));
        } else if (AppConst.SHORT_LINK_TYPE.DOWNLOAD == req.getType()) {
            meta.setSortUrl(this.shortLinkService.getDownloadShortUrl());
        } else if (AppConst.SHORT_LINK_TYPE.FRIEND_SWEEP == req.getType()) {
            meta.setSortUrl(this.shortLinkService.getFriendSweepShortUrl(req));
        } else {
            //默认跳到下载页
            meta.setSortUrl(this.shortLinkService.getDownloadShortUrl());
        }

        return ResultUtil.genSuccessResult(meta);
    }

    @ApiOperation(value = "1-03-4 长链接生成短链接")
    @RequestMapping(value = "/generateShortUrl", method = {RequestMethod.GET, RequestMethod.POST})
    public Json<ShortLinkMeta> generateShortUrl(String url) {
        ShortLinkMeta meta = new ShortLinkMeta();
        meta.setSortUrl(this.shortLinkService.generateShortUrl(url));
        return ResultUtil.genSuccessResult(meta);
    }
}
