package com.bxm.localnews.base.controller;

import com.bxm.localnews.base.service.ShortLinkService;
import com.bxm.localnews.common.constant.ShortLinkTypeEnum;
import com.bxm.localnews.common.dto.ShortLinkMeta;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import static com.bxm.localnews.common.constant.ShortLinkTypeEnum.T;
import static org.apache.commons.lang3.StringUtils.isBlank;

@Api(tags = "1-09 短链接接口", description = "短链接转换与跳转")
@RestController
@RequestMapping("{version}/base/shortLink/public")
@AllArgsConstructor
public class ShortLinkNewController {

    private final ShortLinkService shortLinkService;

    @ApiOperation(value = "1-09-1 [v1]长链接生成短链接 新增短链类型")
    @RequestMapping(value = "generateShortUrlByType", method = {RequestMethod.GET, RequestMethod.POST})
    @ApiVersion(1)
    public Json<ShortLinkMeta> generateShortUrlByType(String url,  String shortLinkType) {

        ShortLinkMeta meta = new ShortLinkMeta();
        meta.setSortUrl(this.shortLinkService.generateShortUrl(url, isBlank(shortLinkType)
                ? T : ShortLinkTypeEnum.valueOf(shortLinkType)));
        return ResultUtil.genSuccessResult(meta);
    }

}
