package com.bxm.localnews.base.controller.webtoken;

import com.bxm.localnews.base.service.webtoken.WebTokenService;
import com.bxm.localnews.common.param.WebTokenParam;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/1/12 8:14 下午
 */
@Api(tags = "1-11 获取站外Token接口")
@RequestMapping("/{version}/base/webToken")
@RestController
@AllArgsConstructor
public class WebTokenController {

    private final WebTokenService webTokenService;

    @ApiOperation(value = "1-11-1 【v1】站外获取令牌", tags = "站外获取令牌")
    @GetMapping("/getToken")
    @ApiVersion(1)
    public ResponseJson<String> getToken(WebTokenParam param) {
        Message resultMsg = webTokenService.getWebToken(param.getCode());
        if (Boolean.FALSE.equals(resultMsg.isSuccess())) {
            return ResponseJson.badReqeuset(resultMsg.getLastMessage()).build();
        }
        return ResponseJson.ok(resultMsg.getParam("webToken"));
    }
}