package com.bxm.localnews.base.facade.controller;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.common.param.GetAvailableDomainInfoParam;
import com.bxm.localnews.common.param.GetViewSceneDomainInfoParam;
import com.bxm.localnews.common.vo.BaseUrlInfo;
import com.bxm.localnews.common.vo.ViewSceneBaseUrl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 *
 * @author Gonzo
 * @date  2020-08-03 11:07
 */
@RestController
@AllArgsConstructor
@Api(tags = "1-105 [内部接口]可用域名的相关接口")
@RequestMapping("facade/base/domain")
public class DomainFacadeController {

    private final BaseUrlFacadeService baseUrlFacadeService;

    @ApiOperation(value = "1-105-1 根据请求参数，获取可用的base url信息", notes = "包含了域名、baseUrl（如果有需要则会拼接）的信息")
    @GetMapping("getBaseUrlInfoByScene")
    public ResponseEntity<BaseUrlInfo> getBaseUrlInfoByScene(GetAvailableDomainInfoParam param) {
        return ResponseEntity.ok(baseUrlFacadeService.getBaseUrlInfo(param));
    }

    @ApiOperation(value = "1-105-2 根据请求参数，获取具体落地页的base url信息", notes = "给网关调用的，根据场景获取落地页的域名")
    @GetMapping("getViewSceneBaseUrl")
    public ResponseEntity<ViewSceneBaseUrl> getViewSceneBaseUrl(GetViewSceneDomainInfoParam param) {
        return ResponseEntity.ok(baseUrlFacadeService.getBaseUrlByViewScene(param));
    }
}
