package com.bxm.localnews.base.facade.controller;

import com.bxm.localnews.base.service.LocationService;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.dto.LocationProvinceAndCityDTO;
import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author zhaoyadong 2019/3/7 9:58
 * @desc
 */
@Api(tags = "1-101 [内部接口]获取位置信息")
@RestController
@RequestMapping("facade/location")
public class LocationFacadeController {

    @Autowired
    private LocationService locationService;

    @ApiOperation(value = "1-101-1 获取定位信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "code", value = "地区编码", required = true)
    })
    @GetMapping("/info")
    public ResponseEntity<LocationDetailDTO> getLocation(@RequestParam("code") String code, BasicParam basicParam) {
        return ResponseEntity.ok(this.locationService.getInternalLocationByGeocode(code, basicParam));
    }

    @ApiOperation(value = "1-101-2 获取所有已开通社区板块的地区")
    @GetMapping("/community/list")
    public ResponseEntity<List<String>> listAllLocation() {
        return ResponseEntity.ok(this.locationService.listAllLocationWithCommunity());
    }

    @ApiOperation(value = "1-101-3 根据地区编码获取省市信息")
    @GetMapping("/provinceAndCityInfo")
    public ResponseEntity<LocationProvinceAndCityDTO> getProvinceAndCityInfo(@RequestParam("areaCode") String areaCode) {
        return ResponseEntity.ok(locationService.getProvinceAndCityInfo(areaCode));
    }


}
