package com.bxm.localnews.base.facade.controller;

import com.bxm.localnews.base.service.webtoken.WebTokenService;
import com.bxm.localnews.common.vo.WebTokenVerifyVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/1/14 4:23 下午
 */
@Api(tags = "1-106 [内部接口]获取Web Token接口")
@RequestMapping("facade/webToken")
@AllArgsConstructor
@RestController
public class WebTokenFacadeController {

    private final WebTokenService webTokenService;

    @ApiOperation(value = "1-106-01 验证webToken是否有效,如有效返回openid", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "webToken", required = true),
    })
    @GetMapping("verify")
    public ResponseEntity<WebTokenVerifyVO> verifyWebToken(@RequestParam(value = "token") String token) {
        return ResponseEntity.ok(webTokenService.verifyWebToken(token));
    }
}