/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.common.constant;

import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import java.util.Arrays;
import java.util.stream.Stream;

public enum TaskEnum {
    READ_PUSH_ARTICLE(11, "\u9605\u8bfb\u63a8\u9001\u65b0\u95fb", new String[]{"otherReward", "goldReward"}, null),
    REGISTER(18, "\u7528\u6237\u6ce8\u518c", new String[]{"moneyReward", "redPacketMoney"}, null),
    SIGN_DAILY(20, "\u6bcf\u65e5\u7b7e\u5230", new String[]{"otherReward", "goldReward"}, null),
    EXCHANGE_GOODS(27, "\u91d1\u5e01\u5151\u6362\u5546\u54c1", new String[]{"otherReward", "goldReward"}, null),
    STORE_ADD_BALANCE(30, "\u79ef\u5206\u5546\u57ce\u6dfb\u52a0\u91d1\u5e01", new String[]{"otherReward", "goldReward"}, null),
    TASK_NEWS_SHARE(9, "\u5206\u4eab", new String[]{"shareArtical", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_NEWS_READ(10, "\u770b\u65b0\u95fb", new String[]{"readReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_INVITED_FRIEND(31, "\u9080\u8bf7\u597d\u53cb", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_VIDEO_READ(32, "\u770b\u89c6\u9891", new String[]{"readReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_IMPROVE_INFO(34, "\u5b8c\u5584\u4e2a\u4eba\u8d44\u6599", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_ACTIVATION_VIP(35, "\u6fc0\u6d3bVIP\u4e00\u5e74", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_FIRST_POST_INTIVATION(36, "\u9996\u6b21\u53d1\u5e16", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED),
    TASK_POST_INTIVATION(37, "\u53d1\u5e16", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED);

    private byte type;
    private String desc;
    private String[] tableColumn;
    private PushMessageEnum pushMessageEnum;

    private TaskEnum(byte type, String desc, String[] tableColumn, PushMessageEnum pushMessageEnum) {
        this.type = type;
        this.desc = desc;
        this.tableColumn = tableColumn;
        this.pushMessageEnum = pushMessageEnum;
    }

    public static String getDescByType(byte type) {
        for (TaskEnum taskTypeEnum : TaskEnum.values()) {
            if (taskTypeEnum.getType() != type) continue;
            return taskTypeEnum.getDesc();
        }
        return null;
    }

    public static String[] getTableColumByType(byte type) {
        for (TaskEnum taskTypeEnum : TaskEnum.values()) {
            if (taskTypeEnum.getType() != type) continue;
            return taskTypeEnum.getTableColumn();
        }
        return null;
    }

    public static PushMessageEnum getPushMessageEnumByDesc(String desc) {
        return Stream.of(TaskEnum.values()).filter(taskTypeEnum -> desc.equals(taskTypeEnum.getDesc())).findAny().get().getPushMessageEnum();
    }

    public static TaskEnum getTaskByDesc(String desc) {
        return Arrays.asList(TaskEnum.values()).stream().filter(taskEnum -> desc.equals(taskEnum.getDesc())).findFirst().get();
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String[] getTableColumn() {
        return this.tableColumn;
    }

    public void setTableColumn(String[] tableColumn) {
        this.tableColumn = tableColumn;
    }

    public PushMessageEnum getPushMessageEnum() {
        return this.pushMessageEnum;
    }
}

