package com.bxm.localnews.common.constant;

/**
 * @author zhaoyadong 2019/5/28 10:09
 * @desc
 */
public enum WxMiniSceneEnum {
    //收藏本地万事通小程序
    COLLECT("1089", TaskEnum.TASK_COLLECT_APPLET_MINI),
    /**
     * 从发现栏进入我的小程序
     **/
    FIND_COLLECT("1103", TaskEnum.TASK_COLLECT_APPLET_MINI),
    /**
     * 从微信聊天主界面下拉
     */
    CHAT_COLLECT("1104", TaskEnum.TASK_COLLECT_APPLET_MINI),

    //关注微信公众号
    FOCUS_ON("0001", TaskEnum.TASK_FOCUS_WECAHT),


    //转发本地新闻
    SHARE_NEWS("0002", TaskEnum.TASK_EVERYDAT_SHARE);


    private String scene;

    private TaskEnum taskEnum;

    WxMiniSceneEnum(String scene, TaskEnum taskEnum) {
        this.scene = scene;
        this.taskEnum = taskEnum;
    }

    public static TaskEnum getTaskEnumByScene(String scene) {
        for (WxMiniSceneEnum wxMiniSceneEnum : WxMiniSceneEnum.values()) {
            if (wxMiniSceneEnum.getScene().equals(scene)) {
                return wxMiniSceneEnum.getTaskEnum();
            }
        }
        return null;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    public TaskEnum getTaskEnum() {
        return taskEnum;
    }

    public void setTaskEnum(TaskEnum taskEnum) {
        this.taskEnum = taskEnum;
    }
}
