package com.bxm.localnews.base.domain;

import com.bxm.localnews.common.entity.TBaseDomain;
import com.bxm.localnews.common.param.DomainListParam;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface BaseDomainExtendMapper extends BaseDomainMapper {

    /**
     * 根据请求参数查询域名列表
     * @param param 请求参数
     * @return 域名列表
     */
    List<TBaseDomain> selectByParam(DomainListParam param);

    /**
     * 根据域名查找对应的域名对象
     * @param domain domain
     * @return 域名对象
     */
    List<TBaseDomain> selectByDomain(String domain);

    /**
     * 移除
     * @param id id
     * @return 移除的个数
     */
    int deleteOne(Long id);

    /**
     * 根据请求参数查询域名列表
     * @return 域名列表
     */
    List<TBaseDomain> selectAllAvailable();
}