package com.bxm.localnews.base.domain;


import com.bxm.localnews.common.entity.DomainInfo;
import com.bxm.localnews.common.entity.DomainPublishInfo;
import com.bxm.localnews.common.param.DomainPublishListParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface BaseDomainPublishExtendMapper extends BaseDomainPublishMapper {

    /**
     * 根据请求参数 获取投放列表
     * @param param param
     * @return 投放列表
     */
    List<DomainPublishInfo> selectByParam(DomainPublishListParam param);

    /**
     * 根据场景获取可用的域名信息列表
     * @param scene required 场景值
     * @param viewScene 落地页场景
     * @param appId option 某些场景是在微信环境下的，所以选用appid对应的域名
     * @return 域名信息列表
     */
    List<DomainInfo> selectAvailableDomainByScene(@Param("scene") byte scene, @Param("viewScene") Byte viewScene, @Param("appId") String appId);

    /**
     * 移除一个投放
     * @param id id
     * @return 移除个数
     */
    int deleteOne(Long id);

    /**
     * 获取所有正在使用中的投放
     * @return 所有正在使用中的投放
     */
    List<DomainPublishInfo> selectAllAvailableDomain();

    /**
     * 获取某个域名的落地页投放集合
     *
     * @param domain 域名
     * @return 落地页投放集合
     */
    List<DomainInfo> getViewSceneByDomain(String domain);
}