/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.integration;

import com.bxm.localnews.base.facade.DomainFacadeService;
import com.bxm.localnews.base.model.dto.AvailableDomainInfo;
import com.bxm.localnews.base.model.dto.ViewSceneDomain;
import com.bxm.localnews.common.constant.DomainScene;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DomainIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(DomainIntegrationService.class);
    private final DomainFacadeService domainFacadeService;

    public Optional<AvailableDomainInfo> getBaseUrlInfoByScene(DomainScene scene, String appId) {
        try {
            ResponseEntity<AvailableDomainInfo> domainInfo = this.domainFacadeService.getBaseUrlInfoByScene(Objects.toString(scene), appId);
            if (Objects.nonNull(domainInfo.getBody())) {
                return Optional.of(domainInfo.getBody());
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u573a\u666f\u83b7\u53d6\u57df\u540d\u5931\u8d25 scene: {} appId: {}", new Object[]{scene, appId, e});
        }
        return Optional.empty();
    }

    public Optional<ViewSceneDomain> getViewSceneBaseUrl(DomainScene.DomainViewScene viewScene) {
        try {
            ResponseEntity<ViewSceneDomain> domainInfo = this.domainFacadeService.getViewSceneBaseUrl(Objects.toString(viewScene));
            if (Objects.nonNull(domainInfo.getBody())) {
                return Optional.of(domainInfo.getBody());
            }
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u573a\u666f\u83b7\u53d6\u57df\u540d\u5931\u8d25 viewScene: {}", (Object)viewScene, (Object)e);
        }
        return Optional.empty();
    }

    private String getByScene(DomainScene scene) {
        Optional<AvailableDomainInfo> baseUrlInfoByScene = this.getBaseUrlInfoByScene(scene, null);
        if (baseUrlInfoByScene.isPresent()) {
            return baseUrlInfoByScene.get().getBaseUrl();
        }
        return "";
    }

    public String getInnerH5BaseUrl() {
        return this.getByScene(DomainScene.INNER_H5);
    }

    public String getOutSideShareBaseUrl() {
        return this.getByScene(DomainScene.OUTSIDE_SHARE);
    }

    public DomainIntegrationService(DomainFacadeService domainFacadeService) {
        this.domainFacadeService = domainFacadeService;
    }
}

