package com.bxm.localnews.base.manage.controller;

import com.bxm.localnews.base.service.manage.DomainManageService;
import com.bxm.localnews.common.param.*;
import com.bxm.localnews.common.vo.DomainInfoVO;
import com.bxm.localnews.common.vo.DomainVO;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author gonzo
 * @date 2020-09-02 19:37
 **/
@Api(tags = "1-63 域名管理", description = "用于管理可用域名")
@RequestMapping("manage/base/domain")
@RestController
@AllArgsConstructor
public class DomainManageController {

    private final DomainManageService domainManageService;

    @ApiOperation(value = "1-63-1 获取域名列表", notes = "根据请求参数返回所有域名列表")
    @GetMapping("list")
    public ResponseJson<PageWarper<DomainVO>> list(DomainListParam param) {
        return ResponseJson.ok(domainManageService.list(param));
    }

    @ApiOperation(value = "1-63-2 添加一个域名", notes = "根据请求参数添加一个域名")
    @PostMapping("add")
    public ResponseJson add(@RequestBody @Validated AddBaseDomainParam param) {
        return ResponseJson.build(domainManageService.add(param));
    }

    @ApiOperation(value = "1-63-3 编辑一个域名", notes = "根据请求参数添加一个域名")
    @PostMapping("edit")
    public ResponseJson edit(@RequestBody @Validated EditBaseDomainParam param) {
        return ResponseJson.build(domainManageService.edit(param));
    }

    @ApiOperation(value = "1-63-4 域名投放列表", notes = "根据请求参数获取域名投放列表")
    @GetMapping("publish/list")
    public ResponseJson<PageWarper<DomainInfoVO>> publishList(DomainPublishListParam param) {
        return ResponseJson.ok(domainManageService.publishList(param));
    }

    @ApiOperation(value = "1-63-5 添加域名投放", notes = "根据请求参数添加域名投放")
    @PostMapping("publish/add")
    public ResponseJson publishAdd(@RequestBody @Validated AddDomainPublishParam param) {
        return ResponseJson.build(domainManageService.publishAdd(param));
    }

    @ApiOperation(value = "1-63-6 编辑域名投放", notes = "根据请求参数编辑域名投放")
    @PostMapping("publish/edit")
    public ResponseJson publishEdit(@RequestBody @Validated EditDomainPublishParam param) {
        return ResponseJson.build(domainManageService.publishEdit(param));
    }

    @ApiOperation(value = "1-63-7 获取所有可用域名列表", notes = "获取所有可用域名列表")
    @GetMapping("listAll")
    public ResponseJson<List<DomainVO>> listAll(DomainListParam param) {
        return ResponseJson.ok(domainManageService.listAll(param));
    }

    @ApiOperation(value = "1-63-8 移除一个域名", notes = "获取所有可用域名列表")
    @GetMapping("deleteOneDomain")
    public ResponseJson deleteOneDomain(Long id) {
        return ResponseJson.build(domainManageService.deleteOneDomain(id));
    }

    @ApiOperation(value = "1-63-9 移除一个域名投放", notes = "获取所有可用域名列表")
    @GetMapping("deleteOneDomainPublish")
    public ResponseJson deleteOneDomainPublish(Long id) {
        return ResponseJson.build(domainManageService.deleteOneDomainPublish(id));
    }

}
