package com.bxm.localnews.base.manage.controller;

import com.bxm.localnews.base.service.manage.WechatMpManageService;
import com.bxm.localnews.common.vo.WechatMpInfoVO;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author gonzo
 * @date 2020-10-30 11:45
 **/
@Api(tags = "1-64 管理微信信息", description = "用于管理微信信息")
@RequestMapping("manage/base/wechatMp")
@RestController
@AllArgsConstructor
public class WechatMpManageController {

    private final WechatMpManageService wechatMpManageService;

    /**
     * 查询所有的微信信息
     *
     * @return 所有的微信信息
     */
    @ApiOperation(value = "1-64-1 查询所有的可用微信信息", notes = "查询所有的可用微信信息")
    @GetMapping("listAllEnable")
    public ResponseJson<List<WechatMpInfoVO>> listAllEnable() {
        return ResponseJson.ok(wechatMpManageService.listAllEnable());
    }
}
