package com.bxm.localnews.common.vo;

import java.io.Serializable;

/**
 * 用户定位信息配置实体
 *
 * @author
 */
public class Location implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 地区编码
     */
    private String code;

    /**
     * 地区简称
     */
    private String name;

    /**
     * 地区全称
     */
    private String fullName;

    /**
     * 是否热门城市（1表示true）
     */
    private Byte hot;

    /**
     * 是否显示（1表示true）
     */
    private Byte show;

    /**
     * 城市级别（2：市、3：县（区））
     */
    private Byte level;

    /**
     * 城市拼音或者首字母
     */
    private String pinyin;

    /**
     * 纬度
     */
    private Double lat;

    /**
     * 经度
     */
    private Double lng;

    /**
     * 该地区是否开启vip
     */
    private Byte enableVip;

    /**
     * 激活VIP需要邀请人数
     */
    private Integer invitedCount;

    /**
     * 地区优惠金额
     */
    private String reductionAmount;

    public String getReductionAmount() {
        return reductionAmount;
    }

    public void setReductionAmount(String reductionAmount) {
        this.reductionAmount = reductionAmount;
    }

    public Byte getEnableVip() {
        return enableVip;
    }

    public void setEnableVip(Byte enableVip) {
        this.enableVip = enableVip;
    }

    public Double getLat() {
        return lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLng() {
        return lng;
    }

    public void setLng(Double lng) {
        this.lng = lng;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Byte getHot() {
        return hot;
    }

    public void setHot(Byte hot) {
        this.hot = hot;
    }

    public Byte getShow() {
        return show;
    }

    public void setShow(Byte show) {
        this.show = show;
    }

    public Byte getLevel() {
        return level;
    }

    public void setLevel(Byte level) {
        this.level = level;
    }

    public String getPinyin() {
        return pinyin;
    }

    public void setPinyin(String pinyin) {
        this.pinyin = pinyin;
    }

    public Integer getInvitedCount() {
        return invitedCount;
    }

    public void setInvitedCount(Integer invitedCount) {
        this.invitedCount = invitedCount;
    }
}