package com.bxm.localnews.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * c_location_relation
 *
 * @author
 */
@ApiModel(description = "微信话术返回实体")
public class LocationRelationDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("关联内容（微信分享语、朋友圈分享语）")
    private String content = "";

    @ApiModelProperty("类型（1、微信分享语，2：朋友圈分享语，3：微信图片 4：朋友圈图片）")
    private Byte type;

    @ApiModelProperty("地区编号")
    private String locationCode;

    @ApiModelProperty("分享图片")
    private String imgUrl;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getLocationCode() {
        return locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

}