package com.bxm.localnews.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author zhaoyadong 2018/10/22 14:56
 */
@Data
@ApiModel(description = "app版本信息")
public class AppVersionDTO {

    @ApiModelProperty("平台类型 1.安卓  2.ios")
    private Integer mobileType;

    @ApiModelProperty("版本号")
    private String version;

    @ApiModelProperty("更新标题")
    private String title;

    @ApiModelProperty("更新内容")
    private String content;

    @ApiModelProperty("下载地址")
    private String downloadLink;

    @ApiModelProperty("更新策略 0.提示更新 1.强制更新 2:静默更新 3：不用更新")
    private Byte isForce;

    @ApiModelProperty("是否处于提包状态 0.否 1.是")
    private Byte status = 0;

    @ApiModelProperty("是否开启：0关闭 1开启")
    private Byte enable;

    @ApiModelProperty("渠道代码")
    private String code;

    @ApiModelProperty("渠道名称")
    private String name;

    @ApiModelProperty("强制更新范围")
    private String forceVersion;

    @ApiModelProperty("创建时间")
    private Date createTime;
}
