package com.bxm.localnews.common.dto;

import com.bxm.newidea.component.vo.BaseBean;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@ApiModel(description = "字典实体")
@EqualsAndHashCode(callSuper = true)
@Data
public class DictDto extends BaseBean {
    private static final long serialVersionUID = -2468694456698256347L;

    @ApiModelProperty("字典选项编码")
    private String code;

    @ApiModelProperty("字典选项文本标签")
    private String label;

    @ApiModelProperty("上级字典ID")
    private Long parentId;

    @ApiModelProperty("下级字典")
    private List<DictDto> children;

    public void addChild(DictDto subDict) {
        if (children == null) {
            children = Lists.newArrayList();
        }
        children.add(subDict);
    }
}
